<?php


namespace Modules\TpsTransfer\Entities;

use App\BusinessLocation;
use App\PurchaseLine;
use App\Transaction;

class NstPrepareStock extends NstBasicModel
{
    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id'];

    protected $table = 'nst_prepare_products';

    protected $fillable = ['business_id', 'transaction_date', 'to_location_id', 'ref_no', 'created_by', 'created_at', 'updated_at', 'product_id', 'variation_id', 'from_location_id', 'is_important', 'shipping_ratio', 'value_per_unit', 'nst_shipping_id', 'unit_price_after_shipping', 'note', 'temp_transfer_quantity', 'purchase_lines_id', 'transfer_quantity', 'status', 'updated_at', 'transaction_id' ];

    /**
     * Get the user who added NST product.
     */
    public function createdBy()
    {
        return $this->belongsTo('App\User', 'created_by');
    }

    /**
     * Attributes to be logged for activity
     */
    public function getLogPropertiesAttribute() {
        return ['is_important', 'note', 'transfer_quantity', 'status'];
    }

    public function to_location()
    {
        return $this->belongsTo(BusinessLocation::class, 'to_location_id');
    }

    public function from_location()
    {
        return $this->belongsTo(BusinessLocation::class, 'from_location_id');
    }

    public function product()
    {
        return $this->belongsTo(\App\Product::class, 'product_id');
    }

    public function purchase_line()
    {
        return $this->belongsTo(PurchaseLine::class, 'purchase_lines_id');
    }

    public function shipping()
    {
        return $this->belongsTo(NstShipping::class, 'nst_shipping_id');
    }

    public function transaction()
    {
        return $this->belongsTo(Transaction::class, 'transaction_id');
    }
}