<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddShippingColumnsToPrepareTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('nst_prepare_products', function (Blueprint $table) {
            $table->decimal('shipping_ratio', 5, 2)->after('is_important');
            $table->decimal('value_per_unit', 22, 4)->after('shipping_ratio');
            $table->decimal('unit_price_after_shipping', 22, 4)->default(0)->after('value_per_unit');
            $table->bigInteger('nst_shipping_id')->unsigned()->nullable()->after('unit_price_after_shipping');
            $table->foreign('nst_shipping_id')->references('id')->on('nst_shipping');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('nst_prepare_products', function (Blueprint $table) {
            $table->dropForeign('nst_prepare_products_nst_shipping_id_foreign');
            $table->dropColumn('shipping_ratio', 'value_per_unit', 'nst_shipping_id');
        });
    }
}
