<?php

namespace Modules\TpsTransfer\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;
use Spatie\Permission\Models\Permission;

class SeedNtsPermissionsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();

        Permission::findOrCreate('tpsTransfer.access_all_locations_from');
        Permission::findOrCreate('tpsTransfer.access_his_locations_from');
        Permission::findOrCreate('tpsTransfer.access_none_locations_from');

        Permission::findOrCreate('tpsTransfer.access_all_locations_to');
        Permission::findOrCreate('tpsTransfer.access_his_locations_to');
        Permission::findOrCreate('tpsTransfer.access_none_locations_to');

        Permission::findOrCreate('tpsTransfer.access_add_stock_transfer');
        Permission::findOrCreate('tpsTransfer.access_prepare_stock_transfer');
        Permission::findOrCreate('tpsTransfer.access_received_stock_transfer');
        Permission::findOrCreate('tpsTransfer.access_list_stock_transfers');
    }
}
