<div class="modal-dialog modal-xl" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close no-print" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title" id="modalTitle">{{$nstProduct->product->name}}</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-9">
                    <div class="col-sm-4 invoice-col">
                        <b>@lang('product.sku'):</b>
                        {{$nstProduct->product->sku }}<br>
                        <b>@lang('product.brand'): </b>
                        {{$nstProduct->product->brand->name ?? '--' }}<br>
                        <b>@lang('product.unit'): </b>
                        {{$nstProduct->product->unit->short_name ?? '--' }}<br>
                        <b>@lang('product.barcode_type'): </b>
                        {{$nstProduct->product->barcode_type ?? '--' }}
                        @php
                            $custom_labels = json_decode(session('business.custom_labels'), true);
                        @endphp
                        @if(!empty($nstProduct->product->product_custom_field1))
                            <br/>
                            <b>{{ $custom_labels['product']['custom_field_1'] ?? __('lang_v1.product_custom_field1') }}: </b>
                            {{$nstProduct->product->product_custom_field1 }}
                        @endif

                        @if(!empty($nstProduct->product->product_custom_field2))
                            <br/>
                            <b>{{ $custom_labels['product']['custom_field_2'] ?? __('lang_v1.product_custom_field2') }}: </b>
                            {{$nstProduct->product->product_custom_field2 }}
                        @endif

                        @if(!empty($nstProduct->product->product_custom_field3))
                            <br/>
                            <b>{{ $custom_labels['product']['custom_field_3'] ?? __('lang_v1.product_custom_field3') }}: </b>
                            {{$nstProduct->product->product_custom_field3 }}
                        @endif

                        @if(!empty($nstProduct->product->product_custom_field4))
                            <br/>
                            <b>{{ $custom_labels['product']['custom_field_4'] ?? __('lang_v1.product_custom_field4') }}: </b>
                            {{$nstProduct->product->product_custom_field4 }}
                        @endif
                        <br>
                        <strong>From @lang('purchase.business_location'):</strong>
                        @if(count($nstProduct->product->product_locations) > 0)
                            {{implode(', ', $nstProduct->product->product_locations->pluck('name')->toArray())}}
                        @else
                            @lang('lang_v1.none')
                        @endif
                        @if(!empty($nstProduct->product->media->first())) <br>
                        <strong>@lang('lang_v1.product_brochure'):</strong>
                        <a href="{{$nstProduct->product->media->first()->display_url}}" download="{{$nstProduct->product->media->first()->display_name}}">
								<span class="label label-info">
									<i class="fas fa-download"></i>
									{{$nstProduct->product->media->first()->display_name}}
								</span>
                        </a>
                        @endif
                    </div>

                    <div class="col-sm-4 invoice-col">
                        <b>@lang('product.category'): </b>
                        {{$nstProduct->product->category->name ?? '--' }}<br>
                        <b>@lang('product.sub_category'): </b>
                        {{$nstProduct->product->sub_category->name ?? '--' }}<br>

                        <b>@lang('product.manage_stock'): </b>
                        @if($nstProduct->product->enable_stock)
                            @lang('messages.yes')
                        @else
                            @lang('messages.no')
                        @endif
                        <br>
                        @if($nstProduct->product->enable_stock)
                            <b>@lang('product.alert_quantity'): </b>
                            {{$nstProduct->product->alert_quantity ?? '--' }}
                        @endif

                        @if(!empty($nstProduct->product->warranty))
                            <br>
                            <b>@lang('lang_v1.warranty'): </b>
                            {{$nstProduct->product->warranty->display_name }}
                        @endif
                    </div>

                    <div class="col-sm-4 invoice-col">
                        <b>@lang('product.expires_in'): </b>
                        @php
                            $expiry_array = ['months'=>__('product.months'), 'days'=>__('product.days'), '' =>__('product.not_applicable') ];
                        @endphp
                        @if(!empty($nstProduct->product->expiry_period) && !empty($nstProduct->product->expiry_period_type))
                            {{$nstProduct->product->expiry_period}} {{$expiry_array[$nstProduct->product->expiry_period_type]}}
                        @else
                            {{$expiry_array['']}}
                        @endif
                        <br>
                        @if($nstProduct->product->weight)
                            <b>@lang('lang_v1.weight'): </b>
                            {{$nstProduct->product->weight }}<br>
                        @endif
                        <b>@lang('product.applicable_tax'): </b>
                        {{$nstProduct->product->product_tax->name ?? __('lang_v1.none') }}<br>
                        @php
                            $tax_type = ['inclusive' => __('product.inclusive'), 'exclusive' => __('product.exclusive')];
                        @endphp
                        <b>@lang('product.selling_price_tax_type'): </b>
                        {{$tax_type[$nstProduct->product->tax_type]  }}<br>
                        <b>@lang('product.product_type'): </b>
                        @lang('lang_v1.' . $nstProduct->product->type)

                    </div>
                    <div class="clearfix"></div>
                    <br>
                    <div class="col-sm-12">
                        {!! $nstProduct->product->product_description !!}
                    </div>
                </div>
                <div class="col-sm-3 col-md-3 invoice-col">
                    <div class="thumbnail">
                        <img src="{{$nstProduct->product->image_url}}" alt="Product image">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <h4>@lang('lang_v1.combo'):</h4>
                </div>
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table bg-gray">
                            <tr class="bg-green">
                                <th>@lang('product.product_name')</th>
                                @can('view_purchase_price')
                                    <th>@lang('product.default_purchase_price') (@lang('product.exc_of_tax'))</th>
                                    <th>@lang('product.default_purchase_price') (@lang('product.inc_of_tax'))</th>
                                @endcan
                                @can('access_default_selling_price')
                                    @can('view_purchase_price')
                                        <th>@lang('product.profit_percent')</th>
                                    @endcan
                                    <th>@lang('product.default_selling_price') (@lang('product.exc_of_tax'))</th>
                                    <th>@lang('product.default_selling_price') (@lang('product.inc_of_tax'))</th>
                                @endcan
                                <th>@lang('sale.qty')</th>
                                <th class="text-center">
                                    @lang('lang_v1.total_amount_exc_tax')
                                </th>
                                <th>@lang('lang_v1.variation_images')</th>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="col-md-12 text-right">
                    <strong>@lang('product.default_selling_price'): </strong>
                    <span class="display_currency" data-currency_symbol="true">{{$nstProduct->product->variations->first()->sell_price_inc_tax}}</span>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-primary no-print"
                    aria-label="Print"
                    onclick="$(this).closest('div.modal').printThis();">
                <i class="fa fa-print"></i> @lang( 'messages.print' )
            </button>
            <button type="button" class="btn btn-default no-print" data-dismiss="modal">@lang( 'messages.close' )</button>
        </div>
    </div>
</div>
