<?php $__env->startSection('title', __('Purchase New Report (Beta)')); ?>
<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1><?php echo app('translator')->get('Purchase New Report (Beta)'); ?></h1>
</section>

<!-- Main content -->
<section class="content no-print">
    <div class="row">
        
            <?php $__env->startComponent('components.filters', ['title' => __('report.filters')]); ?>




<div class="col-md-10 mx-2">
    <label class="form-control bg-dark header-print">User (<?php echo e($printed_user, false); ?>) , Purchase New Report (Beta) and currency convertion unit is  <?php echo e($currency_convertion_unit, false); ?></label>
</div>
<div class="col-md-2 mx-2">
<a href="/additional_reports/purchase_new_report\" style="text-decoration: none;"><button class="form-control bg-dark  button" style="background: #e10f28 !important; color: white; border-radius: 50px; border-style: none; font-weight: 700;">New Report</button></a>
</div>


            <?php echo $__env->renderComponent(); ?>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-body">
                    <div class="table-responsive">
                    <table id="dtBasicExample" class="table table-bordered table-striped text-center" >
                        <!--<caption style="display: none;"><label class="form-control bg-dark header-print">User (<?php echo e($user_name, false); ?>) Payments Transactions At <?php echo e($daterange_new_formate, false); ?> , printed by (<?php echo e($printed_user, false); ?>)</label></caption>-->
                        <thead>
                            <tr>
                                <th>Product Image</th>
                                <th class="d-none">Product Image URL</th>
                                <th>Product sku</th>
                                <th>Product Name</th>
                                <th>Product Current Stock</th>
                                <th>Supplier Description</th>
                                <th>Last Purchased QTY</th>
                                <th>Last Purchased Returned QTY</th>
                                <th>Last Purchased Adjusted QTY</th>
                                <th>Last Purchased Sold QTY</th>
                                <th>Last Purchased Price (EGP)</th>
                                <th>Last Purchased Price (Converted)</th>
                                <th>Year Sold Qty</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $queries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $query): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    
                                    <?php if($query->product_image != null): ?>
                                    <td><img src="https://static-egy.com/uploads/img/<?php echo e($query->product_image, false); ?>" alt="Product image" class="product-thumbnail-small"></td>
                                    <td class="d-none">https://static-egy.com/uploads/img/<?php echo e($query->product_image, false); ?></td>
                                    <?php else: ?>
                                    <td>No Image Available</td>
                                    <td>No Image Available</td>
                                    <?php endif; ?>
                                    <td><?php echo e($query->product_sku, false); ?></td>
                                    <td><?php echo e($query->product_name, false); ?></td>
                                    <td><?php echo e($query->qty_available, false); ?></td>
                                    <td><?php echo e($query->supplier_description, false); ?></td>
                                    <td><?php echo e($query->purchase_quantity, false); ?></td>
                                    <td><?php echo e($query->purchase_quantity_returned, false); ?></td>
                                    <td><?php echo e($query->purchase_quantity_adjusted, false); ?></td>
                                    <td><?php echo e($query->purchase_quantity_sold, false); ?></td>
                                    <td><?php echo e($query->purchase_purchase_price_inc_tax, false); ?></td>
                                    <td><?php echo e(( $query->purchase_purchase_price_inc_tax ) / ($currency_convertion_unit), false); ?></td>
                                    <td><?php echo e($query->year_sold_qty, false); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('javascript'); ?>
<script>
   $(document).ready(function () {
    $('#dtBasicExample').DataTable({  aLengthMenu: [[ "All",10, 25, 50, 75, -1], [ "All",10, 25, 50, 75 , 'All']],
        iDisplayLength: -1,
        order: [[6, 'asc']],
        });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/static/public_html/resources/views/additional_reports/purchase_new_report_details.blade.php ENDPATH**/ ?>