<?php $__env->startSection('title', __('user.edit_user')); ?>

<?php $__env->startSection('content'); ?>

    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1><?php echo app('translator')->get( 'user.edit_user' ); ?></h1>
    </section>

    <!-- Main content -->
    <section class="content">

        <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => str_replace( '#' . auth()->user()->business_id, '', $user->userFullName)]); ?>
            <?php echo Form::open(['url' => action('\Modules\TpsTransfer\Http\Controllers\TpsController@storeUserLocation', [$user->id]), 'method' => 'put']); ?>

                <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $index): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <hr>
                    <div class="row check_group">
                        <div class="col-md-2">
                            <h4><?php echo e($index, false); ?></h4>
                        </div>
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <?php
                                            if($key == 'receive'){
                                                $data = [
                                                        "tpsTransfer.location_access_{$key}_from_all_locations" => "(All) locations in {$index}",
                                                ];
                                            }else{
                                                $data = [
	                                                "tpsTransfer.location_access_{$key}_from_his_locations" => "(His accessed) locations in {$index}",
	                                                "tpsTransfer.location_access_{$key}_from_all_locations" => "(All) locations in {$index}",
                                                    "tpsTransfer.location_access_{$key}_from_selected_locations" => "(selected) locations in {$index}",
                                                ];
                                            }
                                        ?>
                                        <?php echo Form::label($key.'_from',  __('tpsTransfer::lang.from_locations').':'); ?>

                                        <?php echo Form::select('data[]', $data, $userPermissions, ['class' => 'form-control select2 permission', 'style' => 'width:100%', 'data-key' => $key, 'data-destination' => 'from']); ?>

                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <?php
                                        if($key == 'prepare'){
                                            $data = [
                                                    "tpsTransfer.location_access_{$key}_to_all_locations" => "(All) locations in {$index}",
                                            ];
                                        }else{
                                            $data = [
	                                            "tpsTransfer.location_access_{$key}_to_his_locations" => "(His accessed) locations in {$index}",
	                                            "tpsTransfer.location_access_{$key}_to_all_locations" => "(All) locations in {$index}",
                                                "tpsTransfer.location_access_{$key}_to_selected_locations" => "(selected) locations in {$index}",
                                            ];
                                        }
                                        ?>
                                        <?php echo Form::label($key.'_to',  __('tpsTransfer::lang.to_locations').':'); ?>

                                        <?php echo Form::select('data[]', $data, $userPermissions, ['class' => 'form-control select2 permission', 'style' => 'width:100%', 'data-key' => $key, 'data-destination' => 'to']); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div id='<?php echo e($key, false); ?>-from-selection-div' class="form-group hidden">
                                        <?php echo Form::label('locations['.$key.'_from]',  'Selected '.__('purchase.business_location') . ':'); ?>

                                        <?php echo Form::select('locations['.$key.'_from][]', $locations, $userLocations->where('type', $key.'_from')->pluck('location_id'), ['class' => 'form-control select2', 'style' => 'width:100%', 'multiple']); ?>

                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div id='<?php echo e($key, false); ?>-to-selection-div' class="form-group hidden">
                                        <?php echo Form::label('locations['.$key.'_to]',  'Selected '.__('purchase.business_location') . ':'); ?>

                                        <?php echo Form::select('locations['.$key.'_to][]', $locations, $userLocations->where('type', $key.'_to')->pluck('location_id'), ['class' => 'form-control select2', 'style' => 'width:100%', 'multiple']); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <div class="row">
                    <div class="col-md-12">
                        <button type="submit" class="btn btn-primary pull-right"><?php echo app('translator')->get( 'messages.save' ); ?></button>
                    </div>
                </div>

            <?php echo Form::close(); ?>

        <?php echo $__env->renderComponent(); ?>
    </section>
    <!-- /.content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
    <script>
        $(document).on('change', '.permission', function (evt) {
            let key = $(evt.target).data('key');
            let destination = $(evt.target).data('destination');
            let value = $(evt.target).val();

            let div = $('#'+ key +'-'+ destination+'-selection-div')

            if(value === 'tpsTransfer.location_access_'+ key +'_'+ destination +'_selected_locations'){
                div.removeClass('hidden')
            }else{
                div.addClass('hidden')
            }
        });
        $('.permission').each(function(i, obj) {
            $(obj).change()
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/static/public_html/Modules/TpsTransfer/Providers/../Resources/views/user-permission-edit.blade.php ENDPATH**/ ?>