<?php $__env->startSection('title', __('additional_reports.user_payments_transactions')); ?>
<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1><?php echo app('translator')->get('additional_reports.user_payments_transactions'); ?></h1>
</section>

<!-- Main content -->
<section class="content no-print">
    <div class="row">
        
            <?php $__env->startComponent('components.filters', ['title' => __('report.filters')]); ?>




<div class="col-md-10 mx-2">
    <label class="form-control bg-dark header-print">User (<?php echo e($user_name, false); ?>) Payments Transactions At <?php echo e($daterange_new_formate, false); ?></label>
</div>
<div class="col-md-2 mx-2">
<a href="/additional_reports/user_payments_transactions" style="text-decoration: none;"><button class="form-control bg-dark  button" style="background: #e10f28 !important; color: white; border-radius: 50px; border-style: none; font-weight: 700;"><?php echo app('translator')->get('additional_reports.new_report'); ?></button></a>
</div>


            <?php echo $__env->renderComponent(); ?>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-body">
                    <div class="table-responsive">
                    <table id="dtBasicExample" class="table table-bordered table-striped text-center" >
                        <caption style="display: none;"><label class="form-control bg-dark header-print">User (<?php echo e($user_name, false); ?>) Payments Transactions At <?php echo e($daterange_new_formate, false); ?> , printed by (<?php echo e($printed_user, false); ?>)</label></caption>
                        <thead>
                            <tr>
                                <th>User Name</th>
                                <th>Transaction Type</th>
                                <th>Transaction Method</th>
                                <th>Transaction Ref No</th>
                                <th>Transaction Payment Ref No</th>
                                <th>Account Name</th>
                                <th>Transaction Paid On</th>
                                <th>Contact Name</th>
                                <th>Transaction Amount</th>
                                <th>Net</th>
                            </tr>
                        </thead>
                        <tbody>
                            <div style="display: none">
                                <?php echo e($total = 0, false); ?>

                             </div>
                            <?php $__currentLoopData = $transactions_payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <?php if( ($result->transaction_type == "sell_return" && $result->is_return == 1 ) || ($result->transaction_type == "purchase_return" && $result->is_return == 0 ) || ($result->transaction_type == "sell" && $result->is_return == 0 ) ): ?>
                                    <td><?php echo e($result->user_first_name, false); ?> <?php echo e($result->user_last_name, false); ?></td>
                                    <td class="text-success"><?php echo e($result->transaction_type, false); ?></td>
                                    <td><?php echo e($result->transaction_method, false); ?></td>
                                    <td><?php echo e($result->transaction_ref_no, false); ?></td>
                                    <td><?php echo e($result->payment_ref_no, false); ?></td>
                                    <td><?php echo e($result->account_name, false); ?></td>
                                    <td><?php echo e($result->transaction_paid_on, false); ?></td>
                                    <td><?php echo e($result->contact_name, false); ?></td>
                                    <td class="text-success"><?php echo e((1) * $result->transaction_amount, false); ?></td>
                                        <div style="display: none">
                                        	<?php echo e($total += $result->transaction_amount, false); ?>

                                        </div>
                                    <td><?php echo e($total, false); ?></td>
                                    <?php else: ?>
                                    <td><?php echo e($result->user_first_name, false); ?> <?php echo e($result->user_last_name, false); ?></td>
                                        <?php if($result->transaction_type == "sell" && $result->is_return == 1 ): ?>
                                        <td class="text-danger"><?php echo e($result->transaction_type, false); ?>_return</td>
                                        <?php else: ?>
                                        <td class="text-danger"><?php echo e($result->transaction_type, false); ?></td>
                                        <?php endif; ?>
                                    <td><?php echo e($result->transaction_method, false); ?></td>
                                    <td><?php echo e($result->transaction_ref_no, false); ?></td>
                                    <td><?php echo e($result->payment_ref_no, false); ?></td>
                                    <td><?php echo e($result->account_name, false); ?></td>
                                    <td><?php echo e($result->transaction_paid_on, false); ?></td>
                                    <td><?php echo e($result->contact_name, false); ?></td>
                                    <td class="text-danger"><?php echo e((-1) * $result->transaction_amount, false); ?></td>
                                        <div style="display: none">
                                        	<?php echo e($total -= $result->transaction_amount, false); ?>

                                        </div>
                                    <td><?php echo e($total, false); ?></td>
                                    <?php endif; ?>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   
                        </tbody>
                        <tfoot class="bg-gray">
                            <tr>
                                <th colspan='8' > Net</th>
                                <th colspan='2' > <?php echo e(number_format($total , 2), false); ?> </th>
                            </tr>
                        </tfoot>
                    </table>
                    
                    
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('javascript'); ?>
<script>
   $(document).ready(function () {
    $('#dtBasicExample').DataTable({  aLengthMenu: [[ "All",10, 25, 50, 75, -1], [ "All",10, 25, 50, 75 , 'All']],
        iDisplayLength: -1,
        order: [[6, 'asc']],
        });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/static/public_html/resources/views/additional_reports/user_payments_transactions_details.blade.php ENDPATH**/ ?>