<?php $__env->startSection('title', __('tpsTransfer::lang.transactions')); ?>

<?php $__env->startSection('content'); ?>

    <!-- Content Header (Page header) -->
    <section class="content-header no-print">
        <h1><?php echo app('translator')->get('lang_v1.stock_transfers'); ?>
        </h1>
    </section>

    <!-- Main content -->
    <section class="content no-print">
        <div class="row">
            <div class="col-md-12">
                <?php $__env->startComponent('components.filters', ['title' => __('report.filters')]); ?>
                    <div class="col-md-3">
                        <div class="form-group">
                            <?php echo Form::label('from_location_id',  __('tpsTransfer::lang.from').__('purchase.business_location') . ':'); ?>

                            <?php echo Form::select('from_location_id', $fromBusinessLocations, 'all', ['id' => 'from_location_id', 'class' => 'form-control select2 main-inputs', 'style' => 'width:100%']); ?>

                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <?php echo Form::label('to_location_id',  'To '.__('purchase.business_location') . ':'); ?>

                            <?php echo Form::select('to_location_id', ['all' => __('business.all_your_business_locations')], 'all', ['id' => 'to_location_id', 'class' => 'form-control select2 main-inputs', 'style' => 'width:100%']); ?>

                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <?php echo Form::label('shipping_id',  __('tpsTransfer::lang.shipping_no').':'); ?>

                            <?php echo Form::select('shipping_id', ['all' => 'All'], 'all', ['id' => 'shipping_id', 'class' => 'form-control select2 main-inputs', 'style' => 'width:100%']); ?>

                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <?php echo Form::label('nst_filter_date_range', __('report.date_range') . ':'); ?>

                            <?php echo Form::text('nst_filter_date_range', null, ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'readonly']); ?>

                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <br>
                            <label>
                                <?php echo Form::checkbox('all_transactions', 1, false, ['class' => 'input-icheck', 'id' => 'all_transactions']); ?> <strong><?php echo app('translator')->get('tpsTransfer::lang.all_transactions'); ?></strong>
                            </label>
                        </div>
                    </div>
                <?php echo $__env->renderComponent(); ?>
            </div>
        </div>
        <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => __('lang_v1.all_stock_transfers')]); ?>
            <?php $__env->slot('tool'); ?>
                <div class="box-tools">
                    <a class="btn btn-block btn-primary" href="<?php echo e(action('\Modules\TpsTransfer\Http\Controllers\TpsAddStockController@index'), false); ?>">
                        <i class="fa fa-plus"></i> <?php echo app('translator')->get('messages.add'); ?></a>
                </div>
            <?php $__env->endSlot(); ?>
            <div class="table-responsive">
                <table class="table table-bordered table-striped ajax_view" id="stock_transfer_table">
                    <thead>
                    <tr>
                        <th><?php echo app('translator')->get('messages.date'); ?></th>
                        <th><?php echo app('translator')->get('purchase.ref_no'); ?></th>
                        <th><?php echo app('translator')->get('lang_v1.location_from'); ?></th>
                        <th><?php echo app('translator')->get('lang_v1.location_to'); ?></th>
                        <th><?php echo app('translator')->get('sale.status'); ?></th>
                        <th><?php echo app('translator')->get('lang_v1.shipping_charges'); ?></th>
                        <th><?php echo app('translator')->get('stock_adjustment.total_amount'); ?></th>
                        <th><?php echo app('translator')->get('purchase.additional_notes'); ?></th>
                        <th><?php echo app('translator')->get('messages.action'); ?></th>
                    </tr>
                    </thead>
                </table>
            </div>
        <?php echo $__env->renderComponent(); ?>
    </section>

    <?php echo $__env->make('stock_transfer.partials.update_status_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <section id="receipt_section" class="print_section"></section>

    <!-- /.content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
    <script>
        $(document).ready(function() {
            //Add products
            if ($('#search_product_for_srock_adjustment').length > 0) {
                //Add Product
                $('#search_product_for_srock_adjustment')
                    .autocomplete({
                        source: function(request, response) {
                            $.getJSON(
                                '/products/list',
                                { location_id: $('#location_id').val(), term: request.term },
                                response
                            );
                        },
                        minLength: 2,
                        response: function(event, ui) {
                            if (ui.content.length == 1) {
                                ui.item = ui.content[0];
                                if (ui.item.qty_available > 0 && ui.item.enable_stock == 1) {
                                    $(this)
                                        .data('ui-autocomplete')
                                        ._trigger('select', 'autocompleteselect', ui);
                                    $(this).autocomplete('close');
                                }
                            } else if (ui.content.length == 0) {
                                swal(LANG.no_products_found);
                            }
                        },
                        focus: function(event, ui) {
                            if (ui.item.qty_available <= 0) {
                                return false;
                            }
                        },
                        select: function(event, ui) {
                            if (ui.item.qty_available > 0) {
                                $(this).val(null);
                                stock_transfer_product_row(ui.item.variation_id);
                            } else {
                                alert(LANG.out_of_stock);
                            }
                        },
                    })
                    .autocomplete('instance')._renderItem = function(ul, item) {
                    if (item.qty_available <= 0) {
                        var string = '<li class="ui-state-disabled">' + item.name;
                        if (item.type == 'variable') {
                            string += '-' + item.variation;
                        }
                        string += ' (' + item.sub_sku + ') (Out of stock) </li>';
                        return $(string).appendTo(ul);
                    } else if (item.enable_stock != 1) {
                        return ul;
                    } else {
                        var string = '<div>' + item.name;
                        if (item.type == 'variable') {
                            string += '-' + item.variation;
                        }
                        string += ' (' + item.sub_sku + ') </div>';
                        return $('<li>')
                            .append(string)
                            .appendTo(ul);
                    }
                };
            }

            $('select#location_id').change(function() {
                if ($(this).val()) {
                    $('#search_product_for_srock_adjustment').removeAttr('disabled');
                } else {
                    $('#search_product_for_srock_adjustment').attr('disabled', 'disabled');
                }
                $('table#stock_adjustment_product_table tbody').html('');
                $('#product_row_index').val(0);
                update_table_total();
            });

            $(document).on('change', 'input.product_quantity', function() {
                update_table_row($(this).closest('tr'));
            });
            $(document).on('change', 'input.product_unit_price', function() {
                update_table_row($(this).closest('tr'));
            });

            $(document).on('click', '.remove_product_row', function() {
                swal({
                    title: LANG.sure,
                    icon: 'warning',
                    buttons: true,
                    dangerMode: true,
                }).then(willDelete => {
                    if (willDelete) {
                        $(this)
                            .closest('tr')
                            .remove();
                        update_table_total();
                    }
                });
            });

            //Date picker
            $('#transaction_date').datetimepicker({
                format: moment_date_format + ' ' + moment_time_format,
                ignoreReadonly: true,
            });

            jQuery.validator.addMethod(
                'notEqual',
                function(value, element, param) {
                    return this.optional(element) || value != param;
                },
                'Please select different location'
            );

            $('form#stock_transfer_form').validate({
                rules: {
                    transfer_location_id: {
                        notEqual: function() {
                            return $('select#location_id').val();
                        },
                    },
                },
            });
            $('#save_stock_transfer').click(function(e) {
                e.preventDefault();

                if ($('table#stock_adjustment_product_table tbody').find('.product_row').length <= 0) {
                    toastr.warning(LANG.no_products_added);
                    return false;
                }
                if ($('form#stock_transfer_form').valid()) {
                    $('form#stock_transfer_form').submit();
                } else {
                    return false;
                }
            });

            stock_transfer_table = $('#stock_transfer_table').DataTable({
                processing: true,
                serverSide: true,
                scrollY: "130vh",
                scrollX: true,
                scrollCollapse: true,
                aaSorting: [],
                ajax: {
                    url: '<?php echo e(action('\Modules\TpsTransfer\Http\Controllers\TpsController@transactions'), false); ?>',
                    data: function(d) {
                        if ($('#from_location_id').length) {
                            d.from_location_id = $('#from_location_id').val();
                        }
                        if ($('#to_location_id').length) {
                            d.to_location_id = $('#to_location_id').val();
                        }
                        if ($('#shipping_id').length) {
                            d.shipping_id = $('#shipping_id').val();
                        }
                        if ($('#all_transactions').is(':checked')) {
                            d.all_transactions = $('#all_transactions').is(':checked');
                        }

                        var start = '';
                        var end = '';
                        if ($('#nst_filter_date_range').val()) {
                            start = $('input#nst_filter_date_range')
                                .data('daterangepicker')
                                .startDate.format('YYYY-MM-DD');
                            end = $('input#nst_filter_date_range')
                                .data('daterangepicker')
                                .endDate.format('YYYY-MM-DD');
                        }
                        d.start_date = start;
                        d.end_date = end;

                        d = __datatable_ajax_callback(d);
                    },
                },
                columnDefs: [
                    {
                        targets: 8,
                        orderable: false,
                        searchable: false,
                    },
                ],
                columns: [
                    { data: 'transaction_date', name: 'transaction_date' },
                    { data: 'ref_no', name: 'ref_no' },
                    { data: 'location_from', name: 'l1.name' },
                    { data: 'location_to', name: 'l2.name' },
                    { data: 'status', name: 'status' },
                    { data: 'shipping_charges', name: 'shipping_charges' },
                    { data: 'final_total', name: 'final_total' },
                    { data: 'additional_notes', name: 'additional_notes' },
                    { data: 'action', name: 'action' },
                ],
                fnDrawCallback: function(oSettings) {
                    __currency_convert_recursively($('#stock_transfer_table'));
                },
            });
            var detailRows = [];

            $('#stock_transfer_table tbody').on('click', '.view_stock_transfer', function() {
                var tr = $(this).closest('tr');
                var row = stock_transfer_table.row(tr);
                var idx = $.inArray(tr.attr('id'), detailRows);

                if (row.child.isShown()) {
                    $(this)
                        .find('i')
                        .removeClass('fa-eye')
                        .addClass('fa-eye-slash');
                    row.child.hide();

                    // Remove from the 'open' array
                    detailRows.splice(idx, 1);
                } else {
                    $(this)
                        .find('i')
                        .removeClass('fa-eye-slash')
                        .addClass('fa-eye');

                    row.child(get_stock_transfer_details(row.data())).show();

                    // Add to the 'open' array
                    if (idx === -1) {
                        detailRows.push(tr.attr('id'));
                    }
                }
            });

            // On each draw, loop over the `detailRows` array and show any child rows
            stock_transfer_table.on('draw', function() {
                $.each(detailRows, function(i, id) {
                    $('#' + id + ' .view_stock_transfer').trigger('click');
                });
            });

            //Delete Stock Transfer
            $(document).on('click', 'button.delete_stock_transfer', function() {
                swal({
                    title: LANG.sure,
                    icon: 'warning',
                    buttons: true,
                    dangerMode: true,
                }).then(willDelete => {
                    if (willDelete) {
                        var href = $(this).data('href');
                        $.ajax({
                            method: 'DELETE',
                            url: href,
                            dataType: 'json',
                            success: function(result) {
                                if (result.success) {
                                    toastr.success(result.msg);
                                    stock_transfer_table.ajax.reload();
                                } else {
                                    toastr.error(result.msg);
                                }
                            },
                        });
                    }
                });
            });
        });

        function stock_transfer_product_row(variation_id) {
            var row_index = parseInt($('#product_row_index').val());
            var location_id = $('select#location_id').val();
            $.ajax({
                method: 'POST',
                url: '/stock-adjustments/get_product_row',
                data: { row_index: row_index, variation_id: variation_id, location_id: location_id, type: 'stock_transfer' },
                dataType: 'html',
                success: function(result) {
                    $('table#stock_adjustment_product_table tbody').append(result);
                    update_table_total();
                    $('#product_row_index').val(row_index + 1);
                },
            });
        }

        function update_table_total() {
            var table_total = 0;
            $('table#stock_adjustment_product_table tbody tr').each(function() {
                var this_total = parseFloat(__read_number($(this).find('input.product_line_total')));
                if (this_total) {
                    table_total += this_total;
                }
            });

            $('span#total_adjustment').text(__number_f(table_total));

            if ($('input#shipping_charges').length) {
                var shipping_charges = __read_number($('input#shipping_charges'));
                table_total += shipping_charges;
            }

            $('span#final_total_text').text(__number_f(table_total));
            $('input#total_amount').val(table_total);
        }

        $(document).on('change', '#shipping_charges', function() {
            update_table_total();
        });

        $(document).on('change', 'select.sub_unit', function() {
            var tr = $(this).closest('tr');
            var selected_option = $(this).find(':selected');
            var multiplier = parseFloat(selected_option.data('multiplier'));
            var allow_decimal = parseInt(selected_option.data('allow_decimal'));
            tr.find('input.base_unit_multiplier').val(multiplier);

            var base_unit_price = tr.find('input.hidden_base_unit_price').val();

            var unit_price = base_unit_price * multiplier;
            var unit_price_element = tr.find('input.product_unit_price');
            __write_number(unit_price_element, unit_price);

            var qty_element = tr.find('input.product_quantity');
            var base_max_avlbl = qty_element.data('qty_available');
            var error_msg_line = 'pos_max_qty_error';

            if (tr.find('select.lot_number').length > 0) {
                var lot_select = tr.find('select.lot_number');
                if (lot_select.val()) {
                    base_max_avlbl = lot_select.find(':selected').data('qty_available');
                    error_msg_line = 'lot_max_qty_error';
                }
            }
            qty_element.attr('data-decimal', allow_decimal);
            var abs_digit = true;
            if (allow_decimal) {
                abs_digit = false;
            }
            qty_element.rules('add', {
                abs_digit: abs_digit,
            });

            if (base_max_avlbl) {
                var max_avlbl = parseFloat(base_max_avlbl) / multiplier;
                var formated_max_avlbl = __number_f(max_avlbl);
                var unit_name = selected_option.data('unit_name');
                var max_err_msg = __translate(error_msg_line, {
                    max_val: formated_max_avlbl,
                    unit_name: unit_name,
                });
                qty_element.attr('data-rule-max-value', max_avlbl);
                qty_element.attr('data-msg-max-value', max_err_msg);
                qty_element.rules('add', {
                    'max-value': max_avlbl,
                    messages: {
                        'max-value': max_err_msg,
                    },
                });
                qty_element.trigger('change');
            }
            qty_element.valid();
            update_table_row($(this).closest('tr'));
        });

        function update_table_row(tr) {
            var quantity = parseFloat(__read_number(tr.find('input.product_quantity')));
            var multiplier = 1;

            if (tr.find('select.sub_unit').length) {
                multiplier = parseFloat(
                    tr.find('select.sub_unit')
                        .find(':selected')
                        .data('multiplier')
                );
            }
            quantity = quantity * multiplier;

            var unit_price = parseFloat(tr.find('input.hidden_base_unit_price').val());
            var row_total = 0;
            if (quantity && unit_price) {
                row_total = quantity * unit_price;
            }
            tr.find('input.product_line_total').val(__number_f(row_total));
            update_table_total();
        }

        function get_stock_transfer_details(rowData) {
            var div = $('<div/>')
                .addClass('loading')
                .text('Loading...');
            $.ajax({
                url: '/stock-transfers/' + rowData.DT_RowId,
                dataType: 'html',
                success: function(data) {
                    div.html(data).removeClass('loading');
                },
            });

            return div;
        }

        $(document).on('click', 'a.stock_transfer_status', function(e) {
            e.preventDefault();
            var href = $(this).data('href');
            var status = $(this).data('status');
            $('#update_stock_transfer_status_modal').modal('show');
            $('#update_stock_transfer_status_form').attr('action', href);
            $('#update_stock_transfer_status_form #update_status').val(status);
            $('#update_stock_transfer_status_form #update_status').trigger('change');
        });

        $(document).on('submit', '#update_stock_transfer_status_form', function(e) {
            e.preventDefault();
            var form = $(this);
            var data = form.serialize();

            $.ajax({
                method: 'post',
                url: $(this).attr('action'),
                dataType: 'json',
                data: data,
                beforeSend: function(xhr) {
                    __disable_submit_button(form.find('button[type="submit"]'));
                },
                success: function(result) {
                    if (result.success == true) {
                        $('div#update_stock_transfer_status_modal').modal('hide');
                        toastr.success(result.msg);
                        stock_transfer_table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                    $('#update_stock_transfer_status_form')
                        .find('button[type="submit"]')
                        .attr('disabled', false);
                },
            });
        });
        $(document).on('shown.bs.modal', '.view_modal', function() {
            __currency_convert_recursively($('.view_modal'));
        });

        $('#nst_filter_date_range').daterangepicker(
            dateRangeSettings,
            function (start, end) {
                $('#nst_filter_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
            }
        );
        $('#nst_filter_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $('#nst_filter_date_range').val('');
        });

        $('#from_location_id').on('change', function(e) {
            // Prevent actual form submission
            e.preventDefault();

            var from_location_id = $('#from_location_id').val();

            if(!from_location_id){
                return
            }
            if(from_location_id == 'all'){
                console.log('all')
                $('#to_location_id').html()
                $('#shipping_id').html()
            }
            $.ajax({
                method: 'POST',
                url: '<?php echo e(action('\Modules\TpsTransfer\Http\Controllers\TpsController@getToLocationByFromLocationId'), false); ?>',
                dataType: 'html',
                data: { from_location_id: from_location_id, status: 'complete' , preAppendAll: true },
                success: function(result) {
                    if (result) {
                        $('#to_location_id').html(result).change();
                    }
                },
            });
        })

        $('#to_location_id').on('change', function(e) {
            // Prevent actual form submission
            e.preventDefault();

            var from_location_id = $('#from_location_id').val();
            if(!from_location_id || from_location_id === 'all'){
                return
            }
            var to_location_id = $('#to_location_id').val();
            if(!to_location_id){
                return
            }
            $.ajax({
                method: 'POST',
                url: '<?php echo e(action('\Modules\TpsTransfer\Http\Controllers\TpsController@getShippingIdsWithLocations'), false); ?>',
                dataType: 'html',
                data: { from_location_id: from_location_id, to_location_id: to_location_id, status: 'complete' , preAppendAll: true },
                success: function(result) {
                    if (result) {
                        $('#shipping_id').html(result).change();
                    }
                },
            });
        })

        $(".input-icheck").on('ifToggled', function(e) {
            var all_transactions_status = $('#all_transactions').is(':checked')

            $('#to_location_id').attr('disabled', all_transactions_status);
            $('#from_location_id').attr('disabled', all_transactions_status);
            $('#nst_filter_date_range').attr('disabled', all_transactions_status);
            $('#shipping_id').attr('disabled', all_transactions_status);

            $('#stock_transfer_table').DataTable().ajax.reload()
        });

        $(document).on('change', '#to_location_id, #from_location_id, #nst_filter_date_range, #shipping_id', function(){
            $('#stock_transfer_table').DataTable().ajax.reload();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/static/public_html/Modules/TpsTransfer/Providers/../Resources/views/transactions.blade.php ENDPATH**/ ?>