
<?php $__env->startSection('title', __('tpsTransfer::lang.prepare')); ?>

<?php $__env->startSection('content'); ?>
    <div id="block-waiting-div" style="display:none;">
        <h3><?php echo e(__('tpsTransfer::lang.inserting_data'), false); ?></h3>
    </div>
    <link rel="stylesheet" href="https://cdn.datatables.net/rowgroup/1.1.4/css/rowGroup.dataTables.min.css">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1><?php echo app('translator')->get('tpsTransfer::lang.prepare_products'); ?>
            <small><?php echo app('translator')->get('tpsTransfer::lang.prepare_transfer_stage'); ?></small>
        </h1>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <?php $__env->startComponent('components.filters', ['title' => __('report.filters')]); ?>
                    <div class="col-md-3">
                        <div class="form-group">
                            <?php echo Form::label('type', __('product.product_type') . ':'); ?>

                            <?php echo Form::select('type', ['single' => __('lang_v1.single'), 'variable' => __('lang_v1.variable'), 'combo' => __('lang_v1.combo')], null, ['class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'type', 'placeholder' => __('lang_v1.all')]); ?>

                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <?php echo Form::label('category_id', __('product.category') . ':'); ?>

                            <?php echo Form::select('category_id', $categories, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'category_id', 'placeholder' => __('lang_v1.all')]); ?>

                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <?php echo Form::label('sub_category_id', __('product.sub_category') . ':'); ?>

                            <?php echo Form::select('sub_category_id', [], [], ['class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'sub_category_id']); ?>

                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <?php echo Form::label('brand_id', __('product.brand') . ':'); ?>

                            <?php echo Form::select('brand_id', $brands, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'brand_id', 'placeholder' => __('lang_v1.all')]); ?>

                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <?php echo Form::label('from_location_id',  __('tpsTransfer::lang.from').__('purchase.business_location') . ':'); ?>

                            <?php echo Form::select('from_location_id', $fromBusinessLocations, null, ['id' => 'from_location_id', 'class' => 'form-control select2 main-inputs', 'style' => 'width:100%']); ?>

                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <?php echo Form::label('to_location_id',  'To '.__('purchase.business_location') . ':'); ?>

                            <?php echo Form::select('to_location_id', [], null, ['id' => 'to_location_id', 'class' => 'form-control select2 main-inputs', 'style' => 'width:100%']); ?>

                        </div>
                    </div>
                <?php echo $__env->renderComponent(); ?>
            </div>
        </div>
        <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => __('tpsTransfer::lang.prepare_products')]); ?>
            <?php
                $colspan = 12;
                $custom_labels = json_decode(session('business.custom_labels'), true);
            ?>
            <table class="table table-bordered table-striped ajax_view hide-footer" id="prepare_data" style="width: 100%;">
                <thead>
                <tr>
                    <th><input type="checkbox" id="selectAll" data-table-id="prepare_data"></th>
                    <th><?php echo app('translator')->get('sale.product'); ?></th>
                    <th><?php echo app('translator')->get('lang_v1.lot_number'); ?></th>
                    <th><?php echo app('translator')->get('product.sku'); ?></th>
                    <th><?php echo app('translator')->get('product.category'); ?></th>

                    <th><?php echo app('translator')->get('product.brand'); ?></th>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_purchase_price')): ?>
                        <?php
                            $colspan++;
                        ?>
                        <th><?php echo app('translator')->get('tpsTransfer::lang.avg_unit_purchase_price'); ?></th>
                    <?php endif; ?>
                    <th><?php echo e(__('tpsTransfer::lang.from'), false); ?> <?php echo app('translator')->get('purchase.business_location'); ?> <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('lang_v1.product_business_location_tooltip') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?></th>
                    <th><?php echo app('translator')->get('lang_v1.stock_transfer'); ?></th>
                    <th><?php echo e(__('tpsTransfer::lang.to'), false); ?> <?php echo app('translator')->get('purchase.business_location'); ?> <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('lang_v1.product_business_location_tooltip') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?></th>

                    <th><?php echo app('translator')->get('lang_v1.date'); ?></th>
                    <th><?php echo app('translator')->get('messages.action'); ?></th>

                </tr>
                </thead>
            </table>
            <div class="form-group text-center">
                <?php if(auth()->user()->can('tpsTransfer.can_delete_nst_row')): ?>
                    <button type="button" class="btn btn-danger " data-toggle="modal" data-target="#delete_selected_confirm"><?php echo e(__('tpsTransfer::lang.delete_selected_data'), false); ?></button>
                <?php endif; ?>
                <button data-status='prepare' class="btn btn-primary btn-flat btn-login updatePrepareData"><?php echo app('translator')->get('messages.save'); ?></button>
                <button data-status='receive' class="btn btn-primary btn-flat btn-login updatePrepareData"><?php echo e(__('tpsTransfer::lang.save_and_send_to_receive'), false); ?></button>
                <span class="btn btn-primary btn-flat btn-login add-shipping"><?php echo e(__('tpsTransfer::lang.add_shipping'), false); ?></span>
            </div>
        <?php echo $__env->renderComponent(); ?>
    </section>
    <!-- /.content -->

    <!-- Notes Modal -->
    <div class="modal fade" id="add_notes" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title"><?php echo e(__('purchase.additional_notes'), false); ?></h4>
                </div>
                <div class="modal-body">
                    <textarea rows='5' style="width:100%;" id="notes_content" name=""></textarea>
                </div>
                <div class="modal-footer">
                    <div class='text-center'>
                        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__('messages.close'), false); ?></button>
                        <button type="button" data-id="" data-dismiss="modal" class="btn btn-info save_notes_button" id="save_notes_button"><?php echo e(__('messages.save'), false); ?></button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Confirm Modal -->
    <?php if(auth()->user()->can('tpsTransfer.can_delete_nst_row')): ?>
        <div class="modal fade" id="delete_confirm" role="dialog">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <h4 class="modal-title"><?php echo e(__('tpsTransfer::lang.confirm_delete'), false); ?></h4>
                    </div>
                    <div class="modal-body">
                        <h3><?php echo __('tpsTransfer::lang.confirm_delete_message'); ?></h3>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__('messages.close'), false); ?></button>
                        <button type="button" data-dismiss="modal" class="btn btn-danger confirm_delete_row_button" id="delete_row_button"><?php echo e(__('messages.delete'), false); ?></button>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Delete All Data Confirm Modal -->
    <?php if(auth()->user()->can('tpsTransfer.can_delete_nst_row')): ?>
        <div class="modal fade" id="delete_selected_confirm" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title"><?php echo e(__('tpsTransfer::lang.confirm_delete_selected_data'), false); ?></h4>
                </div>
                <div class="modal-body">
                    <h3><?php echo __('tpsTransfer::lang.confirm_delete_selected_data_message'); ?></h3>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__('messages.close'), false); ?></button>
                    <button type="button" data-dismiss="modal" class="btn btn-danger" id="confirm_delete_selected_data_button"><?php echo e(__('messages.delete'), false); ?></button>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Add Shipping Modal -->
    <div class="modal fade" id="add_shipping" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <?php echo Form::open(['id' => 'add_shipping_table_form' ]); ?>

                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="modalTitle"><?php echo e(__('tpsTransfer::lang.add_shipping'), false); ?></h4>
                </div>
                <div class="modal-body" id="add_shipping_modal_body">
                </div>
                <div class="modal-footer">
                    <div class='text-center'>
                        <span id="confirm_shipping_modal_button" class="btn btn-primary"><?php echo e(__('tpsTransfer::lang.save_and_send_to_receive'), false); ?></span>
                        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo app('translator')->get( 'messages.close' ); ?></button>
                    </div>
                </div>
                <?php echo Form::close(); ?>


            </div><!-- /.modal-content -->
        </div><!-- /.modal-dialog -->
    </div>
    <!-- Product info modal -->
    <div class="modal fade" tabindex="-1" role="dialog" id="view_product_modal">
    </div>
    <?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script src="https://malsup.github.io/jquery.blockUI.js"></script>
    <script src="https://cdn.datatables.net/rowgroup/1.1.4/js/dataTables.rowGroup.min.js"></script>
    <script src="<?php echo e(asset('js/product.js?v=' . $asset_v), false); ?>"></script>
    <script src="<?php echo e(asset('js/opening_stock.js?v=' . $asset_v), false); ?>"></script>

    <script type="text/javascript">
        let prepareTpsData = new Object();
        let prepareDoneTpsData = new Object();

        $(document).ready(function () {
            __select2($('.select2'));

            prepare_data = $('#prepare_data').DataTable({
                aaSorting: [],
                rowGroup: {
                    dataSrc: function(data) {
                        return data.product_name+'-'+data.sku
                    },
                    startRender: function ( rows, group ) {
                        return '<a onclick="callCoreProductInfoModal(this)" data-href="'+rows.data()[0]['data-href']+'">'+group+'</a>';
                    }
                },
                processing: true,
                serverSide: true,
                scrollY: "130vh",
                scrollX: true,
                scrollCollapse: true,
                ajax: {
                    "url": "<?php echo e(action('\Modules\TpsTransfer\Http\Controllers\TpsPrepareStockController@table'), false); ?>",
                    "type": "POST",
                    "data": function (d) {
                        d.type = $('#type').val();
                        d.category_id = $('#category_id').val();
                        d.sub_category_id = $('#sub_category_id').val();
                        d.brand_id = $('#brand_id').val();
                        d.from_location_id = $('#from_location_id').val();
                        d.to_location_id = $('#to_location_id').val();
                        d = __datatable_ajax_callback(d);
                    }
                },
                columnDefs: [ {
                    "targets": [0],
                    "orderable": false,
                    "searchable": false
                } ],
                columns: [
                    {data: 'row_checkbox', sortable: false, searchable: false, className: "selectable_td input"},
                    {data: 'product_name', name: 'products.name'},
                    {data: 'lot_number', name: 'purchase_lines.lot_number', className: "selectable_td"},
                    {data: 'sku', name: 'products.sku', className: "selectable_td"},
                    {data: 'category', name: 'c1.name', className: "selectable_td"},
                    // {data: 'sub_category', name: 'c2.name', className: "selectable_td"},
                    {data: 'brand', name: 'brands.name', className: "selectable_td"},
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_purchase_price')): ?>
                    { data: 'purchase_price', name: 'purchase_lines.purchase_price', searchable: false, className: "selectable_td"},
                        <?php endif; ?>
                    {data: 'from_location_name', name: 'from_business_locations.name', className: "selectable_td"},
                    {data: 'transfer_quantity_input', sortable: false, searchable: false, className: "clickable_td"},
                    {data: 'to_location_name', name: 'to_business_locations.name', className: "selectable_td"},
                    {data: 'created_at', name: 'created_at'},
                    {data: 'actions', name: 'actions', sortable: false, searchable: false, className: "button"},
                ],
                lengthMenu: [[10, 25, 50, 200, 500], [10, 25, 50, 200, 500]],
                rowCallback: function (row, data) {
                    // write old inputs
                    if(prepareTpsData[data['id']]){
                        if(prepareTpsData[data['id']]['accepted']){
                            checkbox = $(row).find('input[type=checkbox]');
                            $(row).find('input[type="checkbox"]').prop('checked', true);
                            $(row).addClass("selected");
                        }

                        if(prepareTpsData[data['id']]['transfer_quantity']){
                            $(row).find('input[type="number"]').val(prepareTpsData[data['id']]['transfer_quantity']);
                        }

                        if(prepareTpsData[data['id']]['is_important'] == 1){
                            $(row).addClass("bg-yellow");
                        }

                        if(prepareTpsData[data['id']]['note']){
                            if (prepareTpsData[data['id']]['note'] != "") {
                                $(row).find('#actions_btn_'+data['id']).addClass("btn-success")
                            } else {
                                $(row).find('#actions_btn_'+data['id']).removeClass("btn-success")
                            }
                        }
                    }else{
                        prepareTpsData[data['id']] = {};
                        prepareTpsData[data['id']]['transfer_quantity'] = data['transfer_quantity'];
                        prepareTpsData[data['id']]['is_important'] = data['is_important'];
                        prepareTpsData[data['id']]['note'] = data['note'];

                        if(data['is_important'] == 1){
                            $(row).addClass("bg-yellow");
                        }

                        if(data['note']){
                            $(row).find('#actions_btn_'+data['id']).addClass("btn-success")
                        }
                    }
                },
            });

            // delete all data if from location || to location changed
            $(document).on('change', '#from_location_id, #to_location_id', function(){
                if(prepareTpsData){
                    for (let key in prepareTpsData) delete prepareTpsData[key]
                }
                if(prepareDoneTpsData){
                    for (let key in prepareDoneTpsData) delete prepareDoneTpsData[key]
                }
            });

            $(document).on('change', '#type, #category_id, #sub_category_id, #brand_id, #from_location_id, #to_location_id', function(){
                $('#prepare_data').DataTable().ajax.reload();
            });

            $('#prepare_data tbody').on('click', 'tr td.selectable_td:not(".input")', function () {
                checkbox = $(this).parent().find('input[type=checkbox]');
                checkbox.prop("checked", !checkbox.prop("checked")).change();
            });

            // Return add shipping modal content
            $(document).on("click", ".add-shipping", function (e) {
                e.preventDefault();
                $.ajax({
                    type: 'POST',
                    url: '<?php echo e(action('\Modules\TpsTransfer\Http\Controllers\TpsPrepareStockController@addShippingModal'), false); ?>',
                    data: {
                        tpsData: prepareDoneTpsData,
                    },
                    success: function (response) {
                        // Add response in Modal body
                        $('#add_shipping_modal_body').html(response);

                        // Display Modal
                        $("#add_shipping").modal('show');
                    }
                });

            });
        });

        $(document).on('change', '#category_id',function () {
            var category = $(this).val();

            if(category == ''){
                $('#sub_category_id').html('<option value="">None</option>')
            }
        });

        $(document).on("keyup change", ".transfer_quantity", function () {
            // Get value of input, max and min
            var current = $(this).val();
            var max = parseInt($(this).attr("max"));

            // Compare the max and min with the current value
            if (current <= max) {
                return;
            } else {
                value = $(this).val(max)
            }
        });

        $(document).on("change", ".product-row-input", function () {
            id = $(this).data('id');
            name = $(this).data('name');
            var tr = $(this).closest('tr');

            if(!prepareTpsData[id]){
                prepareTpsData[id] = {};
            }
            if(name == 'transfer_quantity'){
                prepareTpsData[id]["transfer_quantity"] = $(this).val();
            }else if(name == 'accepted'){
                if($(this).is(":checked")){
                    prepareTpsData[id][name] = 1
                    prepareDoneTpsData[id] = prepareTpsData[id]
                    tr.addClass('selected');
                }else{
                    prepareTpsData[id][name] = 0
                    delete prepareDoneTpsData[id]
                    tr.removeClass('selected');
                }
            }
        });

        $(document).on("click", ".delete_row_button", function () {
            id = $(this).data('id');
            $("#delete_row_button").attr('data-id',id);
        });

        $(document).on("click", ".confirm_delete_row_button", function () {
            // Delete row from prepare table by id
            $.ajax({
                type: 'DELETE',
                url: '<?php echo e(action('\Modules\TpsTransfer\Http\Controllers\TpsPrepareStockController@destroy'), false); ?>',
                data: {
                    _token: $("meta[name='csrf-token']").attr("content"),
                    id: $("#delete_row_button").attr('data-id'),
                },
                success: function(r) {
                    // console.log('success')
                    if((r.status) && (r.status == 'success')){
                        $('#prepare_data').DataTable().ajax.reload();
                    }else{
                        let msg
                        $.unblockUI();
                        if(r.msg){
                            msg = r.msg
                        }else{
                            msg = '<?php echo e(__('tpsTransfer::lang.an_error_has_been_occurred'), false); ?>'
                        }
                        toastr.error(msg);
                    }
                },
            });
        });

        $(document).on("click", "#confirm_delete_selected_data_button", function () {
            // Delete row from prepare table by id
            $.ajax({
                type: 'DELETE',
                url: '<?php echo e(action('\Modules\TpsTransfer\Http\Controllers\TpsPrepareStockController@destroySelected'), false); ?>',
                data: {
                    _token: $("meta[name='csrf-token']").attr("content"),
                    prepareDoneTpsData: prepareDoneTpsData,
                },
                success: function(r) {
                    // console.log('success')
                    if((r.status) && (r.status == 'success')){
                        $('#prepare_data').DataTable().ajax.reload();
                    }else{
                        let msg
                        $.unblockUI();
                        if(r.msg){
                            msg = r.msg
                        }else{
                            msg = '<?php echo e(__('tpsTransfer::lang.an_error_has_been_occurred'), false); ?>'
                        }
                        toastr.error(msg);
                    }
                },
            });
        });

        $(document).on("click", ".add_notes", function () {
            id = $(this).data('id');
            $("#save_notes_button").attr('data-id',id);

            if((prepareTpsData[id]) && (prepareTpsData[id]['note']) ){
                $("#notes_content").val(prepareTpsData[id]['note']);
            }
        });

        $(document).on("click",".save_notes_button",function(){
            content = $("#notes_content").val();
            $("#notes_content").val('');

            id = $("#save_notes_button").attr('data-id');
            prepareTpsData[id]["note"] = content;

            if (content != "") {
                $("#actions_btn_"+id).addClass("btn-success");
            } else {
                $("#actions_btn_"+id).removeClass("btn-success");
            }
        })

        // Check/uncheck all rows
        $('#selectAll').click(function () {
            $('.product-row-input').prop('checked', $(this).is(":checked")).change()
        });

        // Get product info
        function callCoreProductInfoModal(el) {
            $.ajax({
                url: $(el).data('href'),
                dataType: 'html',
                success: function(result) {
                    $('#view_product_modal').html(result).modal('show');
                },
            });

        }

        function requestWaitingMessage(){
            var seconds = 31;
            handle = setInterval(function() {
                --seconds;
                $('#block-waiting-div').html('<h3><?php echo e(__('tpsTransfer::lang.less_than'), false); ?>'+seconds+'</h3>');

                if(seconds <= 0){
                    clearInterval(handle);
                    $('#block-waiting-div').html('<h3><?php echo e(__('tpsTransfer::lang.validating_data'), false); ?></h3>');
                }
            }, 1000);
        };

        $(document).on('shown.bs.modal', 'div.view_product_modal, div.view_modal, #view_product_modal',
            function(){
                var div = $(this).find('#view_product_stock_details');
                if (div.length) {
                    $.ajax({
                        url: "<?php echo e(action('\App\Http\Controllers\ReportController@getStockReport'), false); ?>"  + '?for=view_product&product_id=' + div.data('product_id'),
                        dataType: 'html',
                        success: function(result) {
                            div.html(result);
                            __currency_convert_recursively(div);
                        },
                    });
                }
                __currency_convert_recursively($(this));
        });

        $(document).on("click", ".updatePrepareData", function (e) {
            // Prevent actual form submission
            e.preventDefault();
            $.blockUI({ message: '<?php echo e(__('tpsTransfer::lang.preparing_data'), false); ?>' });

            $('#prepare_data').DataTable().page.len( -1 ).ajax.reload( function() { //todo need testing

                // Send data by ajax to server side to start auto process and return with products and qty
                $.ajax({
                    type: 'PUT',
                    url: '<?php echo e(action('\Modules\TpsTransfer\Http\Controllers\TpsPrepareStockController@update'), false); ?>',
                    data: {
                        status: $(e.target).data('status'),
                        prepareDoneTpsData: prepareDoneTpsData,
                    },
                    beforeSend: function() {
                        requestWaitingMessage()
                        $.blockUI({ message: $('#block-waiting-div') });
                    },
                    success: function(r) {
                        // console.log('success')
                        if((r.status) && (r.status == 'success')){
                            $.unblockUI();
                            if(r.redirect){
                                window.location.href = r.redirect;
                            }
                        }else{
                            let msg
                            $.unblockUI();
                            if(r.msg){
                                msg = r.msg
                            }else{
                                msg = '<?php echo e(__('tpsTransfer::lang.an_error_has_been_occurred'), false); ?>'
                            }
                            toastr.error(msg);
                        }
                    },
                    error: function(xhr) { // if error occurred
                        $.unblockUI();
                        toastr.error('<?php echo e(__('tpsTransfer::lang.an_error_has_been_occurred'), false); ?>');
                        return;
                    }
                });
            })
        });

        jQuery(function($) {
            $('#from_location_id').on('change', function(e) {
                // Prevent actual form submission
                e.preventDefault();

                var from_location_id = $('#from_location_id').val();
                $.ajax({
                    method: 'POST',
                    url: '<?php echo e(action('\Modules\TpsTransfer\Http\Controllers\TpsController@getToLocationByFromLocationId'), false); ?>',
                    dataType: 'html',
                    data: { from_location_id: from_location_id, status: 'prepare' },
                    success: function(result) {
                        if (result) {
                            $('#to_location_id').html(result).change();
                        }
                    },
                });
            }).trigger('change');
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/static/public_html/Modules/TpsTransfer/Providers/../Resources/views/prepare.blade.php ENDPATH**/ ?>