
<?php $__env->startSection('title', __('Product Extra Info Details (Beta)')); ?>

<?php $__env->startSection('css'); ?>
<!-- Add DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap4.min.css">
<style>
    .selected {
        background-color: #acbad4 !important;
    }
    .product-thumbnail-small {
        max-width: 50px;
        height: auto;
    }
    .data-input-group {
        display: flex;
        margin-bottom: 10px;
    }
    .alert-success {
        color: #155724;
        background-color: #d4edda;
        border-color: #c3e6cb;
        padding: 10px;
        margin-bottom: 20px;
        border-radius: 4px;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1><?php echo app('translator')->get('Product Extra Info Details (Beta)'); ?></h1>
</section>

<!-- Main content -->
<section class="content no-print">
    <div class="row">
        <?php $__env->startComponent('components.filters', ['title' => __('report.filters')]); ?>
            <div class="col-md-2 mx-2">
                <a href="/additional_reports/product_extra_info" style="text-decoration: none;">
                    <button class="form-control bg-dark button" 
                            style="background: #e10f28 !important; color: white; border-radius: 50px; border-style: none; font-weight: 700;">
                        New Product Data
                    </button>
                </a>
            </div>
        <?php echo $__env->renderComponent(); ?>
    </div>

    <!-- Display success message if available -->
    <?php if(session('status')): ?>
    <div class="row">
        <div class="col-md-12">
            <div class="alert alert-success">
                <?php echo e(session('status'), false); ?>

            </div>
        </div>
    </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-body">
                    <div class="table-responsive">
                        <table id="dtBasicExample" class="table table-bordered table-striped text-center">
                            <thead>
                                <tr>
                                    <th>Product Name</th>
                                    <th>Product sku</th>
                                    <th>Product Custom Field 1</th>
                                    <th>Product Custom Field 2</th>
                                    <th>Product Custom Field 3</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><?php echo e($product->name, false); ?></td>
                                    <td><?php echo e($product->sku, false); ?></td>
                                    <td><?php echo e($product->product_custom_field1, false); ?></td>
                                    <td><?php echo e($product->product_custom_field2, false); ?></td>
                                    <td><?php echo e($product->product_custom_field3, false); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header with-border">
                    <h3 class="box-title">Product Compatibility</h3>
                </div>
                <div class="box-body">
                    <form method="POST" action="/additional_reports/product_extra_info_store">
                        <?php echo e(csrf_field(), false); ?>

                        <div class="row">
                            
                            <!-- SKU Input -->
                            <div class="form-group" style="display: none;">
                                <label for="product_id">Product Id</label>
                                <input type="text" class="form-control" id="product_id" name="product_id" value="<?php echo e($product->id, false); ?>" required>
                            </div>
                        
                            <!-- Compatible Serials Section -->
                            <div class="form-group col-md-6">
                                <label>Compatible Serials</label>
                                <div id="serials-container">
                                    <?php if(isset($compatibleSerials) && count($compatibleSerials) > 0): ?>
                                        <?php $__currentLoopData = $compatibleSerials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $serial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="data-input-group mb-2">
                                            <div class="col-md-10">
                                                <input type="text" class="form-control col-md-8" name="compatible_serials[]" value="<?php echo e($serial, false); ?>">
                                            </div>
                                            <div class="col-md-2">
                                                <div class="data-input-group-append">
                                                    <button class="btn btn-danger remove-serial" type="button">-</button>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                    <!-- Empty row for adding new serials -->
                                    <div class="data-input-group mb-2">
                                        <div class="col-md-10">
                                            <input type="text" class="form-control col-md-8" name="compatible_serials[]" list="serials-list">
                                        </div>
                                        <div class="col-md-2">
                                            <div class="data-input-group-append">
                                                <button class="btn btn-success add-serial" type="button">+</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <datalist id="serials-list">
                                    <?php $__currentLoopData = $compatibleSerials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $serial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($serial, false); ?>">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </datalist>
                            </div>
                        
                            <!-- Compatible Products Section -->
                            <div class="form-group col-md-6">
                                <label>Compatible Products (search by product sku or name)</label>
                                <select class="form-control compatible-products" name="compatible_products[]" multiple="multiple" style="width: 100%;">
                                    <?php if(isset($compatibleProducts) && count($compatibleProducts) > 0): ?>
                                        <?php $__currentLoopData = $compatibleProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $compatibleProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($compatibleProduct->id, false); ?>" selected>
                                                <?php echo e($compatibleProduct->sku, false); ?> - <?php echo e($compatibleProduct->name, false); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            
                            <div class="col-md-12 mt-3">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                        
                    </form>

                </div>
            </div>
        </div>
    </div>
</section>


<?php $__env->stopSection(); ?>


<?php $__env->startSection('javascript'); ?>
<!-- Add required JS libraries first -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap4.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function() {
    // Initialize DataTable
    var table = $('#dtBasicExample').DataTable({
        aLengthMenu: [["All", 10, 25, 50, 75, -1], ["All", 10, 25, 50, 75, 'All']],
        iDisplayLength: -1,
        order: [[0, 'asc']], // Changed to first column since there's no 6th column
    });
    
    // Dynamic Serials Input
    $(document).on('click', '.add-serial', function() {
        const newInput = $(this).closest('.data-input-group').clone();
        newInput.find('input').val('');
        $(this).removeClass('btn-success add-serial').addClass('btn-danger remove-serial').text('-');
        $('#serials-container').append(newInput);
    });
    
    // Remove serial input
    $(document).on('click', '.remove-serial', function() {
        $(this).closest('.data-input-group').remove();
    });

    // Select2 AJAX Implementation
    $('.compatible-products').select2({
        ajax: {
            url: '<?php echo e(route('products.search'), false); ?>',
            dataType: 'json',
            delay: 250,
            type: 'POST', // Change the request type to POST
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: function(params) {
                return {
                    search: params.term,
                    page: params.page
                };
            },
            processResults: function(data) {
                return {
                    results: data.results
                };
            },
            cache: true
        },
        minimumInputLength: 1,
        templateResult: formatProduct,
        templateSelection: formatProductSelection
    });
});

function formatProduct(product) {
    if (product.loading) return product.text;
    return $('<div>').text(product.sku + ' - ' + product.name).html();
}

function formatProductSelection(product) {
    return product.text || (product.sku + ' - ' + product.name);
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/static/public_html/resources/views/additional_reports/product_extra_info_details.blade.php ENDPATH**/ ?>