@extends('layouts.app')
@section('title', __('additional_reports.user_payments_transactions'))


@section('content')

<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1>@lang('additional_reports.user_payments_transactions')</h1>
</section>

<!-- Main content -->
<section class="content no-print">
    <div class="row">
        <form method="post" action="/additional_reports/user_payments_transactions_details">
            {{ csrf_field() }}
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="user_id">Select User:</label>
                        <div class="input-group" style=" width: 100% !important; ">
                            <div class="row">
                                <div class="col-md-3 p-0" style="padding: 0 !important">
                                    <span class="input-group-addon" style="border: none !important;">
                                        <i class="fa fa-search" style="font-size: 20px;"></i>
                                    </span>
                                </div>
                                <div class="col-md-9" style="padding: 0 !important">
                                    <select name="user_id" id="user_id" class="form-control bg-dark " required>
                                            <option value="all" selected='true'>@lang('additional_reports.all')</option>
                                        @foreach($users as $user)
                                            <option value="{{$user->id}}|{{$user->first_name}} {{$user->last_name}}" >{{$user->first_name}} {{$user->last_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="payment_method">Payment Method:</label>
                        <div class="input-group" style=" width: 100% !important; ">
                            <div class="row">
                                <div class="col-md-3 p-0" style="padding: 0 !important">
                                    <span class="input-group-addon" style="border: none !important;">
                                        <i class="fa fa-search" style="font-size: 20px;"></i>
                                    </span>
                                </div>
                                <div class="col-md-9" style="padding: 0 !important">
                                    <select name="payment_method" id="payment_method" class="form-control bg-dark " required>
                                        <option value="all">All</option>
                                        <option value="cash" selected='true'>Cash</option>
                                        <option value="card">Card</option>
                                        <option value="bank_transfer">Bank Transfer</option>
                                        <option value="advance">Advance</option>
                                        <option value="other">Other</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="payment_account">Select Account:</label>
                        <div class="input-group" style=" width: 100% !important; ">
                            <div class="row">
                                <div class="col-md-3 p-0" style="padding: 0 !important">
                                    <span class="input-group-addon" style="border: none !important;">
                                        <i class="fa fa-search" style="font-size: 20px;"></i>
                                    </span>
                                </div>
                                <div class="col-md-9" style="padding: 0 !important">
                                    <select name="payment_account" id="payment_account" class="form-control bg-dark " required>
                                            <option value="all" selected='true'>@lang('additional_reports.all')</option>
                                        @foreach($payment_accounts as $payment_account)
                                            <option value="{{$payment_account->id}}" >{{$payment_account->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!--<div class="col-md-3">-->
                <!--    <div class="form-group">-->
                <!--        <label for="purchase_ref_no">@lang('additional_reports.department_code'):</label>-->
                <!--        <div class="input-group">-->
                <!--            <span class="input-group-addon">-->
                <!--                <i class="fa fa-search"></i>-->
                <!--            </span>-->
                <!--            <input type="text" name="department_code" class="form-control bg-dark ">-->
                <!--        </div>-->
                <!--    </div>-->
                <!--</div>-->
                
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="transfer_action_type">Day Date:</label>
                        <input type="text" id="daterange" class="form-control" name="daterange"  />             
                        
                    </div>
                </div>
                
        </div>
    </div>
    <div class="row">
        <div class="col-md-12 text-center">
            <div class="form-group">
                <input class="button" type="submit" value="@lang('additional_reports.get_data')" name="submit" style="background: #e10f28 !important; color: white; border-radius: 50px; border-style: none; font-weight: 700; padding: 10px 60px;margin-top: 10px;">                     
            </div>
        </div>
        </form>

            @endcomponent
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="nav-tabs-custom">
            
                <div class="tab-content">
                    <h3 class="text-center">@lang('additional_reports.please_select_the_above_data_and_click_on_the_button')</h3>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
    .selectize-dropdown, .selectize-dropdown.form-control{
            position: absolute !important;
    }
</style>

@endsection



@section('javascript')
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js" integrity="sha256-+C0A5Ilqmu4QcSPxrlGpaZxJ04VjsRjKu+G82kl5UJk=" crossorigin="anonymous"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css" integrity="sha256-ze/OEYGcFbPRmvCnrSeKbRTtjG4vGLHXgOqsyLFTRjg=" crossorigin="anonymous" />


    <script type="text/javascript">
    
    $(document).ready(function () {
          $('select').selectize({
              sortField: 'text'
          });
      });
      
    $(function () {
        
      var start = moment().subtract(29, 'days');
      var end = moment();
      $('#daterange').daterangepicker({
        timePicker: true, 
        timePicker24Hour: true,
        startDate: moment().startOf('hour'),
        endDate: moment().startOf('hour').add(32, 'hour'),
        // startDate: start,
        // endDate: end,
        locale: {
          format: 'Y/M/D HH:mm:ss'
        },
        ranges: {
          'Today': [moment(), moment()],
          'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
          'Last 7 Days': [moment().subtract(6, 'days'), moment()],
          'Last 30 Days': [moment().subtract(29, 'days'), moment()],
          'This Month': [moment().startOf('month'), moment().endOf('month')],
          'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],

          'this year': [
            moment()
              .subtract(0, 'year')
              .startOf('year'),
            moment()
              .subtract(0, 'year')
              .endOf('year')
          ],
        }
      });
      
    });
    
    </script>
@endsection