@extends('layouts.app')
@section('title', ' Register Payments Report (Beta)')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1> Cash Payments</h1>
</section>

<!-- Main content -->
<section class="content no-print">

    <!--Get Cash Payment Report to specific locations in custom period-->
    <div class="row">
        <form method="post" action="/additional_reports/register_payments_details">
            {{ csrf_field() }}
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
            <p>Get Cash Payment Report To Specific Locations In Custom Period </p>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="transfer_action_type">Select Location Type:</label>
                        <div class="input-group" style=" width: 100% !important; ">
                            <div class="row">
                                <div class="col-md-3 p-0" style="padding: 0 !important">
                                    <span class="input-group-addon" style="border: none !important;">
                                        <i class="fa fa-search" style="font-size: 20px;"></i>
                                    </span>
                                </div>
                                <div class="col-md-9" style="padding: 0 !important">
                                    <select name="location_type" id="location_type" class="form-control bg-dark ">
                                        <option value="all" selected='true'>@lang('additional_reports.all')</option>
                                        @foreach($business_locations as $business_location)
                                            <option value="{{$business_location->id}}" >{{$business_location->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="transfer_action_type">Date Range:</label>
                        <input type="text" id="reportrange" class="form-control" name="daterange" value="01/01/2018 - 01/15/2018" />                    
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <input class="button" type="submit" value="Get Data" name="submit" style="background: #e10f28 !important; color: white; border-radius: 50px; border-style: none; font-weight: 700; padding: 10px 60px;margin-top: 10px;">                     
                    </div>
                </div>

            @endcomponent
        </div>
        </form>
    </div>
    
    
    <div class="row">
        <div class="col-md-12">
            <div class="nav-tabs-custom">
            
                <div class="tab-content">
                    <h3 class="text-center">Please select the above data and click on the button</h3>
                    <h3 class="text-center">برجاء اتمام الاختيارات والضغط على الزر</h3>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
    .selectize-dropdown, .selectize-dropdown.form-control{
            position: absolute !important;
    }
</style>

@endsection

@section('javascript')
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js" integrity="sha256-+C0A5Ilqmu4QcSPxrlGpaZxJ04VjsRjKu+G82kl5UJk=" crossorigin="anonymous"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css" integrity="sha256-ze/OEYGcFbPRmvCnrSeKbRTtjG4vGLHXgOqsyLFTRjg=" crossorigin="anonymous" />


    <script type="text/javascript">
    
    $(document).ready(function () {
          $('select').selectize({
              sortField: 'text'
          });
      });
      
        $(function () {

      var start = moment().subtract(29, 'days');
      var end = moment();
      $('#reportrange').daterangepicker({
        startDate: start,
        endDate: end,
        ranges: {
          'Today': [moment(), moment()],
          'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
          'Last 7 Days': [moment().subtract(6, 'days'), moment()],
          'Last 30 Days': [moment().subtract(29, 'days'), moment()],
          'This Month': [moment().startOf('month'), moment().endOf('month')],
          'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],

          'this year': [
            moment()
              .subtract(0, 'year')
              .startOf('year'),
            moment()
              .subtract(0, 'year')
              .endOf('year')
          ],
        }
      });
      
    });
    </script>
@endsection