@extends('layouts.app')
@section('title', __('Purchase New Report (Beta)'))
@section('content')

<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1>@lang('Purchase New Report (Beta)')</h1>
</section>

<!-- Main content -->
<section class="content no-print">
    <div class="row">
        
            @component('components.filters', ['title' => __('report.filters')])




<div class="col-md-10 mx-2">
    <label class="form-control bg-dark header-print">User ({{$printed_user}}) , Purchase New Report (Beta) and currency convertion unit is  {{$currency_convertion_unit}}</label>
</div>
<div class="col-md-2 mx-2">
<a href="/additional_reports/purchase_new_report\" style="text-decoration: none;"><button class="form-control bg-dark  button" style="background: #e10f28 !important; color: white; border-radius: 50px; border-style: none; font-weight: 700;">New Report</button></a>
</div>


            @endcomponent
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-body">
                    <div class="table-responsive">
                    <table id="dtBasicExample" class="table table-bordered table-striped text-center" >
                        <!--<caption style="display: none;"><label class="form-control bg-dark header-print">User ({{$user_name}}) Payments Transactions At {{$daterange_new_formate}} , printed by ({{$printed_user}})</label></caption>-->
                        <thead>
                            <tr>
                                <th>Product Image</th>
                                <th class="d-none">Product Image URL</th>
                                <th>Product sku</th>
                                <th>Product Name</th>
                                <th>Product Current Stock</th>
                                <th>Supplier Description</th>
                                <th>Last Purchased QTY</th>
                                <th>Last Purchased Returned QTY</th>
                                <th>Last Purchased Adjusted QTY</th>
                                <th>Last Purchased Sold QTY</th>
                                <th>Last Purchased Price (EGP)</th>
                                <th>Last Purchased Price (Converted)</th>
                                <th>Year Sold Qty</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($queries as $query)
                                <tr>
                                    
                                    @if($query->product_image != null)
                                    <td><img src="https://static-egy.com/uploads/img/{{$query->product_image}}" alt="Product image" class="product-thumbnail-small"></td>
                                    <td class="d-none">https://static-egy.com/uploads/img/{{$query->product_image}}</td>
                                    @else
                                    <td>No Image Available</td>
                                    <td>No Image Available</td>
                                    @endif
                                    <td>{{$query->product_sku}}</td>
                                    <td>{{$query->product_name}}</td>
                                    <td>{{$query->qty_available}}</td>
                                    <td>{{$query->supplier_description}}</td>
                                    <td>{{$query->purchase_quantity}}</td>
                                    <td>{{$query->purchase_quantity_returned}}</td>
                                    <td>{{$query->purchase_quantity_adjusted}}</td>
                                    <td>{{$query->purchase_quantity_sold}}</td>
                                    <td>{{$query->purchase_purchase_price_inc_tax}}</td>
                                    <td>{{ ( $query->purchase_purchase_price_inc_tax ) / ($currency_convertion_unit) }}</td>
                                    <td>{{$query->year_sold_qty}}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@endsection


@section('javascript')
<script>
   $(document).ready(function () {
    $('#dtBasicExample').DataTable({  aLengthMenu: [[ "All",10, 25, 50, 75, -1], [ "All",10, 25, 50, 75 , 'All']],
        iDisplayLength: -1,
        order: [[6, 'asc']],
        });
});
</script>
@endsection