@extends('layouts.app')
@section('title', __('Product Positioning Details (Beta)'))

@section('css')
<!-- Add DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap4.min.css">
<style>
    .selected {
        background-color: #acbad4 !important;
    }
    .product-thumbnail-small {
        max-width: 50px;
        height: auto;
    }
</style>
@endsection

@section('content')
<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1>@lang('Product Positioning Details (Beta)')</h1>
</section>

<!-- Main content -->
<section class="content no-print">
    <div class="row">
        @component('components.filters', ['title' => __('report.filters')])
            <div class="col-md-2 mx-2">
                <a href="/additional_reports/product_racks" style="text-decoration: none;">
                    <button class="form-control bg-dark button" 
                            style="background: #e10f28 !important; color: white; border-radius: 50px; border-style: none; font-weight: 700;">
                        New Report
                    </button>
                </a>
            </div>
        @endcomponent
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-body">
                    <div class="table-responsive">
                        <table id="dtBasicExample" class="table table-bordered table-striped text-center">
                            <thead>
                                <tr>
                                    <th>Product Image</th>
                                    <th>Product sku</th>
                                    <th>Product Name</th>
                                    <th>Product Current Stock</th>
                                    <th>Price</th>
                                    <th>Business Location(s)</th>
                                    <th>Rack</th>
                                    <th>Row</th>
                                    <th>Position</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($products as $product)
                                    <tr>
                                        <td><img src="https://static-egy.com/uploads/img/{{$product->product_image}}" alt="Product image" class="product-thumbnail-small"></td>
                                        <td>{{$product->product_sku}}</td>
                                        <td>{{$product->product_name}}</td>
                                        <td>{{$product->qty_available}}</td>
                                        <td>{{$product->sell_price_inc_tax}}</td>
                                        <td>{{$product->business_location}}</td>
                                        <td>{{$product->rack}}</td>
                                        <td>{{$product->row}}</td>
                                        <td>{{$product->position}}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@section('javascript')
<!-- Add required JS libraries -->
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap4.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.15/jspdf.plugin.autotable.min.js"></script>

<script>
$(document).ready(function() {
    // Initialize DataTable
    var table = $('#dtBasicExample').DataTable({
        aLengthMenu: [["All", 10, 25, 50, 75, -1], ["All", 10, 25, 50, 75, 'All']],
        iDisplayLength: -1,
        order: [[6, 'asc']],
    });

});
</script>
@endsection