@extends('layouts.app')
@section('title', 'Product Extra Info (Beta)')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1>Product Extra Info (Beta)</h1>
</section>

<!-- Main content -->
<section class="content no-print">
    <!-- Display success message if available -->
    @if(session('status'))
    <div class="row">
        <div class="col-md-12">
            <div class="alert alert-success">
                {{ session('status') }}
            </div>
        </div>
    </div>
    @endif

    <!--Get Cash Payment Report to specific locations in custom period-->
    <div class="row">
        <form method="post" action="/additional_reports/product_extra_info_details">
            {{ csrf_field() }}
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="transfer_action_type">Product SKU :</label>
                        <div class="input-group" style=" width: 100% !important; ">
                            <div class="row">
                                <div class="col-md-3 p-0" style="padding: 0 !important">
                                    <span class="input-group-addon" style="border: none !important;">
                                        <i class="fa fa-search" style="font-size: 20px;"></i>
                                    </span>
                                </div>
                                <div class="col-md-9" style="padding: 0 !important">
                                    <input type="text" class="form-control" name="product_sku" required>                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <input class="button" type="submit" value="Get Data" name="submit" style="background: #e10f28 !important; color: white; border-radius: 50px; border-style: none; font-weight: 700; padding: 10px 60px;margin-top: 10px;">                     
                    </div>
                </div>

            @endcomponent
        </div>
        </form>
    </div>
    
    
    <div class="row">
        <div class="col-md-12">
            <div class="nav-tabs-custom">
            
                <div class="tab-content">
                    <h3 class="text-center">Please select the above data and click on the button</h3>
                    <h3 class="text-center">برجاء اتمام الاختيارات والضغط على الزر</h3>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
    .selectize-dropdown, .selectize-dropdown.form-control{
            position: absolute !important;
    }
    .alert-success {
        color: #155724;
        background-color: #d4edda;
        border-color: #c3e6cb;
        padding: 10px;
        margin-bottom: 20px;
        border-radius: 4px;
    }
</style>

@endsection

@section('javascript')
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js" integrity="sha256-+C0A5Ilqmu4QcSPxrlGpaZxJ04VjsRjKu+G82kl5UJk=" crossorigin="anonymous"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css" integrity="sha256-ze/OEYGcFbPRmvCnrSeKbRTtjG4vGLHXgOqsyLFTRjg=" crossorigin="anonymous" />


    <script type="text/javascript">
    
    $(document).ready(function () {
          $('select').selectize({
              sortField: 'text'
          });
      });
      
        $(function () {

      var start = moment().subtract(29, 'days');
      var end = moment();
      $('#reportrange').daterangepicker({
        startDate: start,
        endDate: end,
        ranges: {
          'Today': [moment(), moment()],
          'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
          'Last 7 Days': [moment().subtract(6, 'days'), moment()],
          'Last 30 Days': [moment().subtract(29, 'days'), moment()],
          'This Month': [moment().startOf('month'), moment().endOf('month')],
          'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],

          'this year': [
            moment()
              .subtract(0, 'year')
              .startOf('year'),
            moment()
              .subtract(0, 'year')
              .endOf('year')
          ],
        }
      });
      
    });
    
    
    
    </script>

@endsection