@extends('layouts.app')
@section('title', 'Price Change Details')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1>Price Change Details</h1>
</section>

<!-- Main content -->
<section class="content no-print">
    <div class="row">
        
            @component('components.filters', ['title' => __('report.filters')])
            
            <div class="col-md-10 mx-2">
            <label class="form-control bg-dark header-print">Price Change Details By Ratio {{$ratio}} %</label>
            </div>

            <div class="col-md-2 mx-2">
            <a href="/additional_reports/price_change" style="text-decoration: none;"><button class="form-control bg-dark  button" style="background: #e10f28 !important; color: white; border-radius: 50px; border-style: none; font-weight: 700;">New Report</button></a>
            </div>

            @endcomponent
        <!--</div>-->
        
        
    </div>
    
    <form method="post" action="/additional_reports/price_change_calculations">
        {{ csrf_field() }}
    
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-body">
                    <div class="table-responsive">
                    <table id="dtBasicExample" class="table table-bordered table-striped text-center" >
                        <!--<caption style="display: none;"><label class="form-control bg-dark header-print"> Inventory Control To Location {{$location_name}} and printed by : {{$printed_user}} </label></caption>-->
                        <thead>
                            <tr>
                                <th>Product Image</th>
                                <th>Product Name</th>
                                <th>Product SKU</th>
                                <th>Purchase Price Inc Tax</th>
                                <th>Sell Price Inc Tax</th>
                                <th>Current Profit Percent "%"</th>
                                <th>New Selling Price (sell price will be equal to sell price inc tax)</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($products_data as $product_data)
                            <tr>
                                
                                <td>
                                    <div class="thumbnail">
                      					<img src="{{$product_data->product_image}}" alt="Product image">
                      				</div>
                                </td>
                                <td>
                                    {{$product_data->product_name}}
                                    <input type="hidden" name="variation[{{$product_data->variation_id}}][variation_id]" value="{{$product_data->variation_id}}">
                                </td>
                                <td>
                                    {{$product_data->product_sku}}
                                </td>
                                <td>
                                    {{$product_data->dpp_inc_tax}}
                                    <input type="hidden" name="variation[{{$product_data->variation_id}}][dpp_inc_tax]" value="{{$product_data->dpp_inc_tax}}">
                                </td>
                                <td>
                                    {{$product_data->sell_price_inc_tax}}
                                    <input type="hidden" name="variation[{{$product_data->variation_id}}][sell_price_inc_tax]" value="{{$product_data->sell_price_inc_tax}}">
                                </td>
                                <td>
                                    {{$product_data->profit_percent}}
                                </td>
                                <td>
                                    <input type="text" name="variation[{{$product_data->variation_id}}][new_selling_price_inc_tax]" value="{{ ($product_data->sell_price_inc_tax) * ($ratio/100) }}" >
                                </td>

                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="form-group">
        <input class="button" type="submit" value="Send Data" name="submit" style="background: #e10f28 !important; color: white; border-radius: 50px; border-style: none; font-weight: 700; padding: 10px 60px;margin-top: 10px;">                     
    </div>
    </form>
    
</section>
<!-- /.content -->

<style>
    tr.odd td:first-child,
tr.even td:first-child {
    padding-left: 4em;
}
</style>

@endsection


@section('javascript')
<script>
  $(document).ready(function () {

    $('#dtBasicExample').DataTable({  
        aLengthMenu: [[10, 25, 50, 75, -1], [10, 25, 50, 75, "All"]],
        iDisplayLength: -1,
        });
        
});
</script>
@endsection
