<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('shared_products', function (Blueprint $table) {
            $table->id();
            $table->string('token')->unique()->index();
            $table->unsignedInteger('business_id')->nullable();
            $table->unsignedInteger('user_id')->nullable();
            $table->json('products_data');
            $table->timestamp('expires_at');
            $table->timestamps();
            
            // Add indexes
            $table->index('expires_at');
            $table->index(['business_id', 'user_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('shared_products');
    }
};
