<?php

namespace App\Http\Controllers;
use stdClass;


use App\Brands;
use App\BusinessLocation;
use App\CashRegister;
use App\Category;

use App\Charts\CommonChart;
use App\Contact;

use App\CustomerGroup;
use App\ExpenseCategory;
use App\Product;
use App\SharedProduct;
use App\PurchaseLine;
use App\Restaurant\ResTable;
use App\SellingPriceGroup;
use App\Transaction;
use App\TransactionPayment;
use App\TransactionSellLine;
use App\TransactionSellLinesPurchaseLines;
use App\Unit;
use App\User;
use App\Utils\BusinessUtil;
use App\Utils\ModuleUtil;
use App\Utils\ProductUtil;
use App\Utils\TransactionUtil;
use App\Variation;
use App\VariationLocationDetails;
use Datatables;
use DB;
use Illuminate\Http\Request;
use App\TaxRate;
use Spatie\Activitylog\Models\Activity;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;

class AdditionalReportController extends Controller
{
    /**
     * All Utils instance.
     *
     */
    protected $transactionUtil;
    protected $productUtil;
    protected $moduleUtil;
    protected $businessUtil;
    
    /**
     * Constructor
     *
     * @param ProductUtils $product
     * @return void
     */
    public function __construct(ProductUtil $productUtil, TransactionUtil $transactionUtil)
    {
        $this->productUtil = $productUtil;
        $this->transactionUtil = $transactionUtil;
    }


    /**
     * Stock Minimum level Function 
     *
     * @Array of product and stock level
     */

    public function price_change()
    {
        $business_id = request()->session()->get('user.business_id');
        $categories_data = Category::where('business_id', $business_id)
            ->select(['id', 'name'])
            ->where('parent_id' , 0)
            ->get();
        // $results = DB::table('products as a')
        //                 ->select(DB::raw('a.name AS product_name , v.name AS varitation_name , v.sub_sku AS product_sku , b.qty_available AS available_qty '))
        //                 ->leftjoin('variation_location_details as b','b.product_id', '=', 'a.id')
        //                 ->leftjoin('variations as v','v.id', '=', 'b.variation_id')
        //                 ->leftjoin('business_locations as d','d.id', '=', 'b.location_id')
        //                 ->where('d.business_id', $business_id)
        //                 ->get();
        return view('additional_reports.price_change', compact('categories_data'));
        
    }
    
    public function price_change_details(Request $request)
    {
        $ratio = $request->ratio;
        // dd($ratio);
        if($ratio == null)
        {
            $ratio = 100;
        }
        $category_id = $request->category_id;
        $products_data = DB::table('variations as v')
            ->select(
                        DB::raw(' v.id as variation_id '),
                        // DB::raw(' p.image as product_image '),
                        DB::raw(' IF(p.image = "" , "https://static-egy.com/img/default.png" , CONCAT("https://static-egy.com/uploads/img/", p.image)) as product_image '),
                        DB::raw(' IF(v.name = "DUMMY", p.name , CONCAT(p.name, " + ", v.name)) as product_name '),
                        DB::raw(' v.sub_sku as product_sku '),
                        DB::raw(' v.dpp_inc_tax as dpp_inc_tax '),
                        DB::raw(' v.sell_price_inc_tax as sell_price_inc_tax '),
                        DB::raw(' v.profit_percent as profit_percent ')
                    )
            ->leftjoin('variation_location_details as vld','vld.variation_id', '=', 'v.id')
            ->leftjoin('products as p','p.id', '=', 'v.product_id')
            ->where('p.category_id' , $category_id)
            ->where('vld.qty_available' , '>' , 0)
            ->groupBy('v.sub_sku' )
            ->orderBy('product_name')
            ->get();

        
        return view('additional_reports.price_change_details', compact('products_data' , 'ratio'  ));
    }
    
    public function price_change_calculations(Request $request)
    {
        // dd($request->variation);
            foreach($request->variation as $product_data)
        {
            // dd($product_data['variation_id']);
            $variation_id = $product_data['variation_id'];
            $dpp_inc_tax = $product_data['dpp_inc_tax'];
            $sell_price_inc_tax = $product_data['sell_price_inc_tax'];
            $new_selling_price_inc_tax = $product_data['new_selling_price_inc_tax'];
            
            if($new_selling_price_inc_tax != null && $sell_price_inc_tax != $new_selling_price_inc_tax)
            {
                if($dpp_inc_tax != 0){
                    $profit_percent = ( ( ( $new_selling_price_inc_tax - $dpp_inc_tax ) / $dpp_inc_tax ) * 100 );
                }else{
                    $profit_percent = 100 ;
                }
                $variations = DB::table('variations as v')
                            ->where('v.id', $variation_id)
                            ->update([
                                'v.default_sell_price' => $new_selling_price_inc_tax, 
                                'v.sell_price_inc_tax' => $new_selling_price_inc_tax, 
                                'v.profit_percent' => $profit_percent, 
                                ]);
            }
        } 
        
        $output = ['success' => 1,
                            'msg' => __("lang_v1.updated_success")
                        ];

        return redirect('additional_reports/price_change')->with('status', $output);
    }
    
    /**
     * User Payments Transactions
     *
     * 
     */
     
    public function user_payments_transactions()
    {
        $business_id = request()->session()->get('user.business_id');
        $users = DB::table('users')
                        ->select(DB::raw('users.id , users.first_name, users.last_name '))
                        ->where('users.business_id', $business_id)
                        ->where('users.user_type', "user")
                        ->get();
        $payment_accounts = DB::table('accounts')
                        ->select(DB::raw('accounts.id , accounts.name'))
                        ->where('accounts.business_id', $business_id)
                        ->get();
                        
        // dd($users);
        return view('additional_reports.user_payments_transactions', compact('users' , 'payment_accounts'));
    }

    public function user_payments_transactions_details(Request $request)
    {
        // dd($request->daterange);
        $user_explode = explode('|', $request->user_id);
        $user_id = $user_explode[0];
        $user_name = $user_explode[1];
        
        $payment_account_id = $request->payment_account;
        $payment_method = $request->payment_method;

        $daterange_explode = explode('-', $request->daterange );
        $old_start_date_format = $daterange_explode[0];
        
        // $daterange_explode_date_time = explode(' ', $old_start_date_format);
        // $old_start_date_format_date = $daterange_explode_date_time[0];
        // $old_start_date_format_time = $daterange_explode_date_time[1];
        
        
        // $old_start_date_format_timestamp = strtotime($old_start_date_format_date);
        // $new_start_date_format = date('Y-m-d', $old_start_date_format_timestamp);
        // $startDate = $new_start_date_format;
        
        $startDate = str_replace('/', '-', $old_start_date_format);
        
    // dd($old_start_date_format_date);
    
        $old_end_date_format = $daterange_explode[1];
        // $old_end_date_format_timestamp = strtotime($old_end_date_format);
        // $new_end_date_format = date('Y-m-d', $old_end_date_format_timestamp);
        // $endDate = $new_end_date_format;
        
        $endDate = str_replace('/', '-', $old_end_date_format);
        // dd($endDate);
        
        $daterange_new_formate = $startDate . " - " . $endDate;
        
        $printed_user_first_name = request()->session()->get('user.first_name');
        $printed_user_last_name = request()->session()->get('user.last_name');
        $printed_user = $printed_user_first_name . " " . $printed_user_last_name;
        
        $transactions_payments = [];
        // $transactions_payments_obj = new stdClass;
        
        $results = DB::table('transaction_payments AS tp')
                    ->select(
                        DB::raw(' tp.id as transaction_payment_id '),
                        DB::raw(' tp.is_return as is_return '),
                        DB::raw(' tp.amount as transaction_amount '),
                        DB::raw(' tp.method as transaction_method '),
                        DB::raw(' tp.payment_ref_no as payment_ref_no '),
                        DB::raw(' tp.paid_on as transaction_paid_on '),
                        DB::raw(' tp.is_advance as transaction_is_advance '),
                        DB::raw(' t.type as transaction_type '),
                        DB::raw(' IF(t.invoice_no Is null, t.ref_no , t.invoice_no) as transaction_ref_no '),
                        // DB::raw(' t.ref_no as transaction_ref_no '),
                        DB::raw(' a.name as account_name '),
                        DB::raw(' u.first_name as user_first_name '),
                        DB::raw(' u.last_name as user_last_name '),
                        DB::raw(' c.name as contact_name ')
                    )
                    ->leftjoin('transactions as t','t.id', '=', 'tp.transaction_id')
                    ->leftjoin('accounts as a','a.id', '=', 'tp.account_id')
                    ->leftjoin('users as u','u.id', '=', 'tp.created_by')
                    ->leftjoin('contacts as c','c.id', '=', 't.contact_id')
                    ->whereBetween('tp.paid_on',[$startDate , $endDate]);
                    if($request->user_id != "all")
                    {
                        $results->where('tp.created_by', $user_id);
                    }
                    if($payment_method != "all")
                    {
                        $results->where('tp.method', $payment_method);
                    }
                    if($payment_account_id != "all")
                    {
                        $results->where('tp.account_id', $payment_account_id);
                    }
                        
                    $results = $results->get();
                    
                    // dd("Cooming Soon...");
                    // dd($results);
                    
        foreach($results as $result)
        {
            if($result->transaction_is_advance == 1)
            {
                    // dd('0');
                $results2 = DB::table('transaction_payments AS tp')
                    ->select(
                        DB::raw(' tp.id as tp_id '),
                        
                        DB::raw(' tp.is_return as is_return '),
                        DB::raw(' tp.amount as transaction_amount '),
                        DB::raw(' tp.method as transaction_method '),
                        DB::raw(' tp.payment_ref_no as payment_ref_no '),
                        DB::raw(' tp.paid_on as transaction_paid_on '),
                        DB::raw(' tp.is_advance as transaction_is_advance '),
                        DB::raw(' tp.parent_id as transaction_parent_id '),
                        DB::raw(' t.type as transaction_type '),
                        DB::raw(' IF(t.invoice_no Is null, t.ref_no , t.invoice_no) as transaction_ref_no '),
                        // DB::raw(' t.ref_no as transaction_ref_no '),
                        DB::raw(' a.name as account_name '),
                        DB::raw(' u.first_name as user_first_name '),
                        DB::raw(' u.last_name as user_last_name '),
                        DB::raw(' c.name as contact_name ')
                    )
                    ->leftjoin('transactions as t','t.id', '=', 'tp.transaction_id')
                    ->leftjoin('accounts as a','a.id', '=', 'tp.account_id')
                    ->leftjoin('users as u','u.id', '=', 'tp.created_by')
                    ->leftjoin('contacts as c','c.id', '=', 't.contact_id')
                    ->where('tp.parent_id', $result->transaction_payment_id)
                    // ->where('tp.parent_id', 103390)
                    ->get();
                    
                    // dd($results2);
                foreach($results2 as $result2)
                {
                    if(!in_array( $result2->payment_ref_no, array_column($transactions_payments, 'payment_ref_no')) )
                    {
                        array_push($transactions_payments, (object)[
                            'is_return' => $result2->is_return,
                            'transaction_amount' => $result2->transaction_amount,
                            'transaction_method' => $result2->transaction_method,
                            'payment_ref_no' => $result2->payment_ref_no,
                            'transaction_paid_on' => $result2->transaction_paid_on,
                            'transaction_type' => $result2->transaction_type,
                            'transaction_ref_no' => $result2->transaction_ref_no,
                            'account_name' => $result->account_name,
                            'user_first_name' => $result2->user_first_name,
                            'user_last_name' => $result2->user_last_name,
                            'contact_name' => $result2->contact_name,
                            
                            'type' => 'a',
                        ]);
                    }
                }
                
            }
            else
            {
                
                if(!in_array( $result->payment_ref_no, array_column($transactions_payments, 'payment_ref_no')) && $result->transaction_parent_id == null)
                {
                    array_push($transactions_payments, (object)[
                        'is_return' => $result->is_return,
                        'transaction_amount' => $result->transaction_amount,
                        'transaction_method' => $result->transaction_method,
                        'payment_ref_no' => $result->payment_ref_no,
                        'transaction_paid_on' => $result->transaction_paid_on,
                        'transaction_type' => $result->transaction_type,
                        'transaction_ref_no' => $result->transaction_ref_no,
                        'account_name' => $result->account_name,
                        'user_first_name' => $result->user_first_name,
                        'user_last_name' => $result->user_last_name,
                        'contact_name' => $result->contact_name,
                        
                        'type' => 'b',
                    ]);
                    
                }
                // dd($result->is_return);
            }
            
        }

                    // dd($transactions_payments);
                    // dd($results);
                    // dd($results->toSql());
                    
        return view('additional_reports.user_payments_transactions_details', compact('transactions_payments' , 'daterange_new_formate' , 'printed_user' , 'user_name'));
    }
    
    public function register_payments()
    {
        $business_id = request()->session()->get('user.business_id');
        $business_locations = DB::table('business_locations')
                        ->select(DB::raw('business_locations.id , business_locations.name'))
                        ->where('business_locations.business_id', $business_id)
                        ->get();
        return view('additional_reports.register_payments', compact('users' , 'business_locations'));
    }
    
    public function register_payments_details(Request $request)
    {
        
        // Getting location and date range
        $business_id = request()->session()->get('user.business_id');
        $printed_user_first_name = request()->session()->get('user.first_name');
        $printed_user_last_name = request()->session()->get('user.last_name');
        $daterange_explode = explode('-', $request->daterange);
        $old_start_date_format = $daterange_explode[0];
        $old_start_date_format_timestamp = strtotime($old_start_date_format);
        $new_start_date_format = date('Y-m-d', $old_start_date_format_timestamp);
        $startDate = $new_start_date_format;
    
        $old_end_date_format = $daterange_explode[1];
        $old_end_date_format_timestamp = strtotime($old_end_date_format);
        $new_end_date_format = date('Y-m-d', $old_end_date_format_timestamp);
        $endDate = $new_end_date_format;
        
        $daterange_new_formate = $startDate . " - " . $endDate;
        $printed_user = $printed_user_first_name . " " . $printed_user_last_name;
        $location_type = $request->location_type;
        
        if($location_type == null){
           $results = DB::table('cash_registers as cr')
            ->select(DB::raw('b.name as business_location_name , u.first_name as cashier_first_name , u.last_name as cashier_last_name , cr.location_id , SUM(CASE WHEN tp.is_return = "0" AND tp.method = "cash" THEN tp.amount ELSE 0 END) totalCash, SUM(CASE WHEN tp.is_return = "1" AND tp.method = "cash" THEN tp.amount ELSE 0 END) totalReturn , SUM(CASE WHEN tp.is_return = "0" AND tp.method = "card" THEN tp.amount ELSE 0 END) totalCard , cr.created_at , cr.closed_at'))
            ->leftjoin('transaction_payments as tp','tp.created_by', '=', 'cr.user_id')
            ->leftjoin('users as u','u.id', '=', 'cr.user_id')
            ->leftjoin('business_locations as b','b.id', '=', 'cr.location_id')
            ->whereRaw('tp.paid_on between cr.created_at and cr.closed_at')
            ->whereRaw("cr.created_at LIKE '$startDate%'")
            ->whereRaw('cr.status = "close"')
            ->where('cr.business_id', '=' , $business_id)
            ->groupBy('cr.location_id')
            ->groupBy('cr.user_id')
            ->orderBy('cr.location_id', 'asc')
            ->orderBy('cr.user_id', 'asc')
            ->get(); 
            
        }else{
            $results = DB::table('cash_registers as cr')
            ->select(DB::raw('b.name as business_location_name , u.first_name as cashier_first_name , u.last_name as cashier_last_name , cr.location_id , SUM(CASE WHEN tp.is_return = "0" AND tp.method = "cash" THEN tp.amount ELSE 0 END) totalCash, SUM(CASE WHEN tp.is_return = "1" AND tp.method = "cash" THEN tp.amount ELSE 0 END) totalReturn , SUM(CASE WHEN tp.is_return = "0" AND tp.method = "card" THEN tp.amount ELSE 0 END) totalCard , cr.created_at , cr.closed_at'))
            ->leftjoin('transaction_payments as tp','tp.created_by', '=', 'cr.user_id')
            ->leftjoin('users as u','u.id', '=', 'cr.user_id')
            ->leftjoin('business_locations as b','b.id', '=', 'cr.location_id')
            ->whereRaw('tp.paid_on between cr.created_at and cr.closed_at')
            ->whereRaw("cr.created_at LIKE '$startDate%'")
            ->whereRaw('cr.status = "close"')
            ->where('cr.business_id', '=' , $business_id)
            ->where('b.id', $location_type)
            ->groupBy('cr.location_id')
            ->groupBy('cr.user_id')
            ->orderBy('cr.location_id', 'asc')
            ->orderBy('cr.user_id', 'asc')
            ->get(); 
        }
        
        return view('additional_reports.register_payments_details', compact('results' , 'daterange_new_formate' , 'printed_user'));

    }
    
    public function purchase_new_report()
    {

        $business_id = request()->session()->get('user.business_id');
        $permitted_locations = auth()->user()->permitted_locations();
    
        $contacts_data = Contact::where('business_id', $business_id)
            ->select(
                        DB::raw(' id '),
                        DB::raw(' IF(name != "", name , supplier_business_name) as name ')
                        // DB::raw(' name ')
                    )
            ->where('type' , '!=' , "customer")
            ->get();
    
        $categories_data = Category::where('business_id', $business_id)
            ->select(
                        DB::raw(' id '),
                        DB::raw(' name ')
                    )
            ->where('parent_id' , 0)
            ->get();
        
        $sub_categories_data = Category::where('business_id', $business_id)
            ->select(
                        DB::raw(' id '),
                        DB::raw(' name ')
                    )
            ->where('parent_id' , '!=' , 0)
            ->get();

        return view('additional_reports.purchase_new_report', compact('locations' , 'categories_data' , 'sub_categories_data' , 'contacts_data'));
    }
    
    public function purchase_new_report_details(Request $request)
    {
        $mytime = now();
        // dd($mytime->subDays(365)->toDateTimeString());
        // echo $mytime->toDateTimeString();

        $supplier_id = $request->contact_id;
        $category_id = $request->category_id;
        $sub_category_id = $request->sub_category_id;
        $product_sku = $request->product_sku;
        $currency_convertion_unit = $request->currency_convertion_unit;
        
        $printed_user_first_name = request()->session()->get('user.first_name');
        $printed_user_last_name = request()->session()->get('user.last_name');
        $printed_user = $printed_user_first_name . " " . $printed_user_last_name;
        
        $queries = [];
        $products_data = [];
        
        // $products_data = DB::table('variation_location_details as vld')
        //     ->select(
        //                 DB::raw(' vld.product_id as product_id '),
        //                 DB::raw(' vld.variation_id as variation_id '),
        //                 DB::raw(' IF(v.name = "DUMMY", p.name , CONCAT(p.name, " + ", v.name)) as product_name '),
        //                 DB::raw(' v.sub_sku as product_sku '),
        //                 DB::raw(' p.image as product_image '),
        //                 DB::raw(' p.product_custom_field4 as supplier_description '),
        //                 // DB::raw(' v.name as variation_name '),
        //                 DB::raw(' v.default_purchase_price as default_purchase_price '),
        //                 DB::raw(' sum(vld.qty_available) as qty_available ')
        //             )
        //     // ->leftjoin('product_locations as pl','pl.product_id', '=', 'vld.product_id')
        //     ->leftjoin('products as p','vld.product_id', '=', 'p.id')
        //     ->leftjoin('variations as v','vld.variation_id', '=', 'v.id');
        //     // ->where('pl.location_id' , $location_id)
        //     // ->where('p.id' , '!=', 1)
        //     // ->where('vld.location_id' , $location_id)
        //     if ($sub_category_id != null) {
        //         $products_data->where('p.sub_category_id' , $sub_category_id);
        //     }
        //     if ($category_id != null) {
        //         $products_data->where('p.category_id' , $category_id);
        //     }
        //     if ($product_sku != null) {
        //         $products_data->where('p.sku' , $product_sku);
        //     }
            
        //     $products_data->groupBy('vld.variation_id' );
        //     // dd($products_data->toSql());
        //     $products_data = $products_data->get();
        
        $products = DB::table('variations as v')
            ->select(
                        DB::raw(' v.product_id as product_id '),
                        DB::raw(' v.id as variation_id '),
                        DB::raw(' IF(v.name = "DUMMY", p.name , CONCAT(p.name, " + ", v.name)) as product_name '),
                        DB::raw(' v.sub_sku as product_sku '),
                        DB::raw(' p.image as product_image '),
                        DB::raw(' p.product_custom_field4 as supplier_description '),
                        // DB::raw(' v.name as variation_name '),
                        DB::raw(' v.default_purchase_price as default_purchase_price ')
                        // DB::raw(' sum(vld.qty_available) as qty_available ')
                    )
            // ->leftjoin('product_locations as pl','pl.product_id', '=', 'vld.product_id')
            ->leftjoin('products as p','v.product_id', '=', 'p.id')
            // ->leftjoin('variations as v','vld.variation_id', '=', 'v.id');
            // ->where('pl.location_id' , $location_id)
            // ->where('p.id' , '=', 9377);
            // ->where('vld.location_id' , $location_id)
            ->where('p.is_inactive' , 0);
            if ($sub_category_id != null) {
                $products->where('p.sub_category_id' , $sub_category_id);
            }
            if ($category_id != null) {
                $products->where('p.category_id' , $category_id);
            }
            if ($product_sku != null) {
                $products->where('p.sku' , $product_sku);
            }
            
            // $products->groupBy('v.id' );
            // dd($products->toSql());
            $products = $products->get();
            
            // dd($products->getQueryLog());
            // dd($products);
            
            foreach($products as $product)
            {  
                $product_qty_available = DB::table('variation_location_details as vld')
                    ->select(
                                DB::raw(' sum(vld.qty_available) as qty_available ')
                            )
                    ->where('vld.variation_id' , $product->variation_id)
                    ->groupBy('vld.variation_id' )
                    ->first();
                    
                $purchase_details = DB::table('purchase_lines as pl')
                    ->select(
                                DB::raw(' pl.id as id '),
                                DB::raw(' pl.transaction_id as transaction_id '),
                                DB::raw(' pl.variation_id as purchase_variation_id '),
                                DB::raw(' pl.quantity as purchase_quantity '),
                                DB::raw(' pl.purchase_price_inc_tax as purchase_purchase_price_inc_tax '),
                                DB::raw(' pl.quantity_sold as purchase_quantity_sold '),
                                DB::raw(' pl.quantity_adjusted as purchase_quantity_adjusted '),
                                DB::raw(' pl.quantity_returned as purchase_quantity_returned ')
                            )
                    ->leftjoin('transactions as t','t.id', '=', 'pl.transaction_id')
                    ->where('t.contact_id' , $supplier_id)
                    ->where('t.status' , 'received')
                    ->where('t.type' , 'purchase')
                    ->where('pl.variation_id' , $product->variation_id)
                    ->latest('t.id')
                    ->first();
                    // dd($product->variation_id, $purchase_details);

                array_push($products_data, (object)[
                    'product_id' => $product->product_id,
                    'variation_id' => $product->variation_id,
                    'product_name' => $product->product_name,
                    'product_sku' => $product->product_sku,
                    'product_image' => $product->product_image,
                    'supplier_description' => $product->supplier_description,
                    'default_purchase_price' => $product->default_purchase_price,
                    'qty_available' => (empty($product_qty_available)) ? 0 : $product_qty_available->qty_available,
                    
                    'purchase_quantity' => $purchase_details->purchase_quantity,
                    'purchase_purchase_price_inc_tax' => $purchase_details->purchase_purchase_price_inc_tax,
                    'purchase_quantity_sold' => $purchase_details->purchase_quantity_sold,
                    'purchase_quantity_returned' => $purchase_details->purchase_quantity_returned,
                    'purchase_quantity_adjusted' => $purchase_details->purchase_quantity_adjusted,
                ]);
                    
            }
            // dd($products_data);
            // dd($supplier_id);

            // $transactions = DB::table('transactions as t')
            // ->select(
            //             DB::raw(' t.id as transaction_id ')
            //         )
            // ->where('t.contact_id' , $supplier_id)
            // ->where('t.status' , 'received')
            // ->where('t.type' , 'purchase')
            // ->latest('t.id')
            // ->first();

            // dd($transactions);
            // $purchase_details = DB::table('purchase_lines as pl')
            // ->select(
            //             DB::raw(' pl.variation_id as purchase_variation_id '),
            //             DB::raw(' pl.quantity as purchase_quantity '),
            //             DB::raw(' pl.purchase_price_inc_tax as purchase_purchase_price_inc_tax '),
            //             DB::raw(' pl.quantity_sold as purchase_quantity_sold '),
            //             DB::raw(' pl.quantity_adjusted as purchase_quantity_adjusted '),
            //             DB::raw(' pl.quantity_returned as purchase_quantity_returned ')
            //         )
            // ->where('pl.transaction_id' , $transactions->transaction_id)
            // ->get();
            
            
            // dd($purchase_details);
            // dd($mytime->subDays(365));
            foreach($products_data as $product_data)
            {
                $transaction_sell_lines = DB::table('transaction_sell_lines as tsl')
                ->select(
                            DB::raw(' sum(tsl.quantity - tsl.quantity_returned) as sold_qty ')
                        )
                ->leftjoin('transactions as t','t.id', '=', 'tsl.transaction_id')
                ->where('t.status' , 'final')
                ->where('t.type' , 'sell')
                ->where('tsl.created_at' , '>=' , $mytime->subDays(365))
                ->where('tsl.variation_id' , $product_data->variation_id)
                ->groupBy('tsl.variation_id' )
                ->get();
                
                // dd($transaction_sell_lines);
                // dd($transaction_sell_lines[0]->sold_qty);
                
                array_push($queries, (object)[
                        'product_id' => $product_data->product_id,
                        'variation_id' => $product_data->variation_id,
                        'product_name' => $product_data->product_name,
                        'product_sku' => $product_data->product_sku,
                        'product_image' => $product_data->product_image,
                        'supplier_description' => $product_data->supplier_description,
                        'default_purchase_price' => $product_data->default_purchase_price,
                        'qty_available' => $product_data->qty_available,
                        'purchase_quantity' => $product_data->purchase_quantity,
                        'purchase_purchase_price_inc_tax' => $product_data->purchase_purchase_price_inc_tax,
                        'purchase_quantity_sold' => $product_data->purchase_quantity_sold,
                        'purchase_quantity_returned' => $product_data->purchase_quantity_returned,
                        'purchase_quantity_adjusted' => $product_data->purchase_quantity_adjusted,
                        'year_sold_qty' => $transaction_sell_lines[0]->sold_qty,
                        // 'step_a' => '1',
                    ]);
            }
                // dd($queries);
            
            // foreach($purchase_details as $purchase_detail)
            // {
            //             // dd($purchase_detail);
            //     $collection = collect($queries);
            //     $collection->map(function ($item, $key) use ($purchase_detail ,&$queries) {
            //         dd($item->variation_id , $purchase_detail->purchase_variation_id);
            //         if($item->variation_id == $purchase_detail->purchase_variation_id)
            //         {
            //             dd($purchase_detail);
            //             $item->purchase_quantity = $purchase_detail->purchase_quantity ;
            //             $item->purchase_quantity_returned = $purchase_detail->purchase_quantity_returned ;
            //             $item->purchase_quantity_sold = $purchase_detail->purchase_quantity_sold ;
            //             $item->purchase_quantity_adjusted = $purchase_detail->purchase_quantity_returned ;
            //             $item->purchase_purchase_price_inc_tax = $purchase_detail->purchase_purchase_price_inc_tax ;
            //             $item->step_a = 2 ;
            //         }
            //     });
                    
            // }
                          
            // dd($products_data->toSql());
            
        // dd($queries , $products_data , $supplier_id , $transactions , $purchase_details);
        // dd($location_id);
        // dd($location_name);
        
        return view('additional_reports.purchase_new_report_details', compact('queries' , 'currency_convertion_unit' , 'printed_user'));
    }
    
    
    // public function transfer()
    // {

    //     $business_id = request()->session()->get('user.business_id');
    //     $permitted_locations = auth()->user()->permitted_locations();
        
    //     $transactions = [];
    
    //     $results = DB::table('transactions as t')
    //         ->select(DB::raw('t.id as transaction_id , t.transfer_parent_id as transfer_parent_id , t.ref_no as ref_no'))
    //         ->where('t.status' , "received")
    //         ->where('t.type', 'purchase_transfer')
    //         ->get(); 
            
    //     foreach( $results as $result)
    //     {
    //         $purchase_lines = DB::table('purchase_lines as pl')
    //                 ->select(DB::raw('pl.variation_id as variation_id '))
    //                 ->where('pl.transaction_id' , $result->transaction_id)
    //                 ->get();
            
                
    //         foreach($purchase_lines as $purchase_line)
    //         {
                
    //             $transaction_sell_lines = DB::table('transaction_sell_lines as tsl')
    //                 ->select(DB::raw('tsl.variation_id as variation_id '))
    //                 ->where('tsl.transaction_id' , $result->transfer_parent_id)
    //                 ->get();
                    
    //             foreach()
    //             {
    //                 $transactions = Arr::prepend($transactions , $purchase_line->purchase_id);
                    
    //             }

    //         // dd($transactions);
    //     return view('additional_reports.transfer', compact('transactions' ));
                
    //         }
                
            
    //         // if($transaction_sell_lines_counts != $purchase_lines_counts)
    //         // {
    //         //     $transactions = Arr::prepend($transactions , $result->ref_no);
    //         // }
    //     }
            
    //     // foreach( $results as $result)
    //     // {
    //     //     $transaction_sell_lines_counts = DB::table('transaction_sell_lines as tsl')
    //     //         ->where('tsl.transaction_id' , $result->transfer_parent_id)
    //     //         ->count();
                
    //     //     $purchase_lines_counts = DB::table('purchase_lines as pl')
    //     //         ->where('pl.transaction_id' , $result->transaction_id)
    //     //         ->count();
            
    //     //     if($transaction_sell_lines_counts != $purchase_lines_counts)
    //     //     {
    //     //         $transactions = Arr::prepend($transactions , $result->ref_no);
    //     //     }
    //     // }
    //         // dd($transactions);

    //     return view('additional_reports.transfer', compact('transactions' ));
    // }
    
    public function transfer()
    {

        $business_id = request()->session()->get('user.business_id');
        $permitted_locations = auth()->user()->permitted_locations();
        
        $transactions = [];
    
        $results = DB::table('transactions as t')
            ->select(DB::raw('t.id as transaction_id , t.transfer_parent_id as transfer_parent_id , t.ref_no as ref_no'))
            ->where('t.status' , "received")
            ->where('t.type', 'purchase_transfer')
            ->where('t.id', 122292)
            ->get();
            

        foreach( $results as $result)
        {
            $purchase_lines = DB::table('purchase_lines as pl')
                    ->select(DB::raw('pl.variation_id '))
                    ->where('pl.transaction_id' , $result->transaction_id)
                    ->whereNotExists(function($query)
                        {
                            $query
                                  ->from('transaction_sell_lines as tsl')
                                  ->where('pl.variation_id', '=', 'tsl.variation_id')
                                  ->where('tsl.transaction_id' , $result->transfer_parent_id);
                        })
                    ->get();
            
            dd($purchase_lines);    

        }
            

        return view('additional_reports.transfer', compact('transactions' ));
    }
    
    // public function attendance_check_in()
    // {
    //     $mytime = now()->toDateString();
    //     $business_id = request()->session()->get('user.business_id');
    //     $user_id = request()->session()->get('user.id');
            
    //     $get_essentials_shifts = DB::table('essentials_shifts as es')
    //         ->select(
    //                     DB::raw('es.id as essentials_shift_id'),
    //                     DB::raw('es.type as essentials_shift_type'),
    //                     DB::raw('es.start_time as essentials_shift_start_time'),
    //                     DB::raw('es.end_time as essentials_shift_end_time')
    //                 )
    //         ->leftjoin('essentials_user_shifts as eus','eus.essentials_shift_id', '=', 'es.id')
    //         ->where('eus.user_id', $user_id)
    //         ->where('eus.type', 'fixed_shift')
    //         ->get();
            
    //     $check_attendances = DB::table('essentials_attendances')
    //         ->select(
    //                     DB::raw(' sum(tsl.quantity - tsl.quantity_returned) as sold_qty ')
    //                 )
    //         ->where('clock_in_time ' , 'like' , $mytime.'%')
    //         ->where('business_id', $business_id)
    //         ->where('user_id', $user_id)
    //         ->where('t.id', 122292)
    //         ->get();
    //     return view('additional_reports.attendance_check_in');
    // }
    
    // public function attendance_check_in_details(Request $request)
    // {
    //     $mytime = now();
    //     // dd($mytime->subDays(365)->toDateTimeString());
    //     // echo $mytime->toDateTimeString();
    //     $business_id = request()->session()->get('user.business_id');
    //     $printed_user_first_name = request()->session()->get('user.first_name');
    //     $printed_user_last_name = request()->session()->get('user.last_name');
    //     $printed_user = $printed_user_first_name . " " . $printed_user_last_name;
        
    //     $queries = [];
    //     $products_data = [];
        
        
    //     $products = DB::table('variations as v')
    //         ->select(
    //                     DB::raw(' v.product_id as product_id '),
    //                     DB::raw(' v.id as variation_id '),
    //                     DB::raw(' IF(v.name = "DUMMY", p.name , CONCAT(p.name, " + ", v.name)) as product_name '),
    //                     DB::raw(' v.sub_sku as product_sku '),
    //                     DB::raw(' p.image as product_image '),
    //                     DB::raw(' p.product_custom_field4 as supplier_description '),
    //                     // DB::raw(' v.name as variation_name '),
    //                     DB::raw(' v.default_purchase_price as default_purchase_price ')
    //                     // DB::raw(' sum(vld.qty_available) as qty_available ')
    //                 )
    //         // ->leftjoin('product_locations as pl','pl.product_id', '=', 'vld.product_id')
    //         ->leftjoin('products as p','v.product_id', '=', 'p.id');
    //         // ->leftjoin('variations as v','vld.variation_id', '=', 'v.id');
    //         // ->where('pl.location_id' , $location_id)
    //         // ->where('p.id' , '=', 9377);
    //         // ->where('vld.location_id' , $location_id)
    //         if ($sub_category_id != null) {
    //             $products->where('p.sub_category_id' , $sub_category_id);
    //         }
    //         if ($category_id != null) {
    //             $products->where('p.category_id' , $category_id);
    //         }
    //         if ($product_sku != null) {
    //             $products->where('p.sku' , $product_sku);
    //         }
            
    //         // $products->groupBy('v.id' );
    //         // dd($products->toSql());
    //         $products = $products->get();
            

        
    //     return view('additional_reports.purchase_new_report_details', compact('queries' , 'currency_convertion_unit' , 'printed_user'));
    // }
    
    public function wa_search()
    {
        
        $user_id = request()->session()->get('user.id');
        $business_id = request()->session()->get('user.business_id');
        $permitted_locations = auth()->user()->permitted_locations();
        
        $user_default_locations = User::where('id', $user_id)
                        ->value('custom_field_4');
        
        $business_locations = BusinessLocation::select(
                        DB::raw(' id '),
                        DB::raw(' name '),
                        DB::raw(' location_id ')
                    );
       if ($permitted_locations != 'all') {
            $business_locations->whereIn('id' , $permitted_locations);
        }
        $business_locations = $business_locations->get();
        
        $brands = Brands::where('business_id', $business_id)
            ->select(
                        DB::raw(' id '),
                        DB::raw(' name ')
                    )
            ->get();
        
        $data = Category::where('business_id', $business_id)
            ->select(
                        DB::raw(' id '),
                        DB::raw(' name '),
                        DB::raw(' parent_id ')
                    )
            ->where('category_type' , 'product')
            ->get();

        return view('additional_reports.wa_search', compact('data' , 'business_locations' , 'brands' , 'user_default_locations'));
    }
    
    // public function wa_search_details_old(Request $request)
    // {
    //     $business_id = request()->session()->get('user.business_id');
        
    //     $brand_ids = $request->brands;
    //     $category_ids = $request->categories;
    //     $subCategory_ids = $request->subcategories;
    //     $product_sku = $request->product_sku;
    //     $search_products = $request->search_products;
    //     $business_locations = $request->business_locations;
        
    //     // Process search terms if they exist
    //     $search_terms = [];
    //     if(!empty($search_products)) {
    //         // Split by commas and spaces, then filter out empty values
    //         // $search_terms = preg_split('/,/', $search_products, -1, PREG_SPLIT_NO_EMPTY);
    //         $search_terms = preg_split('/[\s,]+/', $search_products, -1, PREG_SPLIT_NO_EMPTY);
    //     }

    //     $products = DB::table('variations as v')
    //         ->select(
    //                     DB::raw(' IF(v.name = "DUMMY", p.name , CONCAT(p.name, " + ", v.name)) as product_name '),
    //                     DB::raw(' v.sub_sku as product_sku '),
    //                     DB::raw(' p.image as product_image '),
    //                     DB::raw(' v.sell_price_inc_tax as sell_price_inc_tax '),
    //                     DB::raw(' vld.qty_available as qty_available '),
    //                     DB::raw(' bl.name as business_location '),
    //                     DB::raw(' p.product_custom_field3 as brand_names ')
    //                 )
    //         ->leftjoin('products as p','v.product_id', '=', 'p.id')
    //         ->leftjoin('variation_location_details as vld','v.id', '=', 'vld.variation_id')
    //         ->leftjoin('business_locations as bl','bl.id', '=', 'vld.location_id')
    //         ->where('p.business_id', $business_id)
    //         ->where('vld.qty_available', '>', 0);
            
    //     // Apply location filter if specified
    //     if (!empty($business_locations)) {
    //         $products->whereIn('vld.location_id', $business_locations);
    //     }
        
    //     // Apply brand filter if specified
    //     if (!empty($brand_ids)) {
    //         $products->whereIn('p.brand_id', $brand_ids);
    //     }
        
    //     // Apply category filter if specified
    //     if (!empty($category_ids)) {
    //         $products->whereIn('p.category_id', $category_ids);
    //     }
        
    //     // Apply subcategory filter if specified
    //     if (!empty($subCategory_ids)) {
    //         $products->whereIn('p.sub_category_id', $subCategory_ids);
    //     }
        
    //     // Apply SKU filter if specified
    //     if (!empty($product_sku)) {
    //         $products->where('p.sku', 'like', '%'.$product_sku.'%');
    //     }
        
    //     // Apply search terms to multiple fields if search terms exist
    //     if (!empty($search_terms)) {
    //         $products->where(function ($query) use ($search_terms) {
    //             // For each search term, create a nested condition that checks all fields
    //             foreach ($search_terms as $term) {
    //                 if (!empty($term)) {
    //                     $query->where(function ($subQuery) use ($term) {
    //                         $subQuery->where('p.name', 'like', '%'.$term.'%')
    //                                 ->orWhere('p.product_description', 'like', '%'.$term.'%')
    //                                 ->orWhere('p.product_custom_field1', 'like', '%'.$term.'%')
    //                                 ->orWhere('p.product_custom_field2', 'like', '%'.$term.'%')
    //                                 ->orWhere('p.product_custom_field3', 'like', '%'.$term.'%');
    //                     });
    //                 }
    //             }
    //         });
    //     }
        
    //     $products = $products->groupBy('v.id', 'vld.location_id')->orderBy('product_sku')->get();
        
    //     // dd($brand_ids, $category_ids,$subCategory_ids,  $search_terms, $products);
    
    //     return view('additional_reports.wa_search_details', compact('products'));
    // }
    
    public function wa_search_details(Request $request)
    {
        $business_id = request()->session()->get('user.business_id');
        
        $brand_ids = $request->brands;
        $category_ids = $request->categories;
        $subCategory_ids = $request->subcategories;
        $product_sku = $request->product_sku;
        $search_products = $request->search_products;
        $business_locations = $request->business_locations;
        
        // Process search terms if they exist
        $search_terms = [];
        if(!empty($search_products)) {
            // Split by commas and spaces, then filter out empty values
            $search_terms = preg_split('/[\s,]+/', $search_products, -1, PREG_SPLIT_NO_EMPTY);
        }

        $products = DB::table('variations as v')
            ->select(
                        DB::raw(' IF(v.name = "DUMMY", p.name , CONCAT(p.name, " + ", v.name)) as product_name '),
                        DB::raw(' v.sub_sku as product_sku '),
                        DB::raw(' p.image as product_image '),
                        DB::raw(' v.sell_price_inc_tax as sell_price_inc_tax '),
                        DB::raw(' vld.qty_available as qty_available '),
                        DB::raw(' bl.name as business_location '),
                        DB::raw(' p.product_custom_field3 as brand_names ')
                    )
            ->leftjoin('products as p','v.product_id', '=', 'p.id')
            ->leftjoin('variation_location_details as vld','v.id', '=', 'vld.variation_id')
            ->leftjoin('business_locations as bl','bl.id', '=', 'vld.location_id')
            ->where('p.business_id', $business_id)
            ->where('vld.qty_available', '>', 0)
            ->where('p.not_for_selling', 0);
            
        // Apply location filter if specified
        if (!empty($business_locations)) {
            // Remove the 'All' option if present
            $business_locations = array_filter($business_locations, function($value) {
                return $value !== '';
            });
            
            if (!empty($business_locations)) {
                $products->whereIn('vld.location_id', $business_locations);
            }
        }
        
        // Apply brand filter if specified
        if (!empty($brand_ids)) {
            // Remove the 'All' option if present
            $brand_ids = array_filter($brand_ids, function($value) {
                return $value !== '';
            });
            
            if (!empty($brand_ids)) {
                $products->whereIn('p.brand_id', $brand_ids);
            }
        }
        
        // Apply category filter if specified
        if (!empty($category_ids)) {
            // Remove the 'All' option if present
            $category_ids = array_filter($category_ids, function($value) {
                return $value !== '';
            });
            
            if (!empty($category_ids)) {
                $products->whereIn('p.category_id', $category_ids);
            }
        }
        
        // Apply subcategory filter if specified
        if (!empty($subCategory_ids)) {
            // Remove the 'All' option if present
            $subCategory_ids = array_filter($subCategory_ids, function($value) {
                return $value !== '';
            });
            
            if (!empty($subCategory_ids)) {
                $products->whereIn('p.sub_category_id', $subCategory_ids);
            }
        }
        
        // Apply SKU filter if specified
        if (!empty($product_sku)) {
            $products->where('p.sku', 'like', '%'.$product_sku.'%');
        }
        
        // Apply search terms to multiple fields if search terms exist
        if (!empty($search_terms)) {
            $products->where(function ($query) use ($search_terms) {
                // For each search term, create a nested condition that checks all fields
                foreach ($search_terms as $term) {
                    if (!empty($term)) {
                        $query->where(function ($subQuery) use ($term) {
                            $subQuery->where('p.name', 'like', '%'.$term.'%')
                                    ->orWhere('p.product_description', 'like', '%'.$term.'%')
                                    ->orWhere('p.product_custom_field1', 'like', '%'.$term.'%')
                                    ->orWhere('p.product_custom_field2', 'like', '%'.$term.'%')
                                    ->orWhere('p.product_custom_field3', 'like', '%'.$term.'%');
                        });
                    }
                }
            });
        }
        // dd($search_terms);
        
        $products = $products->groupBy('v.id', 'vld.location_id')->orderBy('product_sku')->get();
        
        // dd($products->toSql());
        
        // For AJAX requests, we'll return a partial view
        // For regular requests, we'll return the full view (maintains backward compatibility)
        if ($request->ajax()) {
            return view('additional_reports.wa_search_details', compact('products'));
        } else {
            return view('additional_reports.wa_search_details', compact('products'));
        }
    }
    
    public function wa_search_creation()
    {
        return view('additional_reports.wa_search_creation');
    }
    
    public function wa_search_creation_details(Request $request)
    {
        $business_id = request()->session()->get('user.business_id');
        $quotation_token = $request->quotation_token;

        $token_data = DB::table('shared_products as sp')
            ->select(
                        DB::raw(' sp.token as token '),
                        DB::raw(' u.username as username '),
                        DB::raw(' sp.created_at as created_at '),
                        DB::raw(' sp.expires_at as expires_at ')
                    )
            ->leftjoin('users as u','u.id', '=', 'sp.user_id')
            ->where('sp.business_id', $business_id)
            ->where('sp.token', $quotation_token)
            ->get();
            
        return response()->json(['data' => $token_data]);
        // For AJAX requests, we'll return a partial view
        // For regular requests, we'll return the full view (maintains backward compatibility)
        // if ($request->ajax()) {
        //     return view('additional_reports.wa_search_creation_details', compact('token_data'));
        // } else {
        //     return view('additional_reports.wa_search_creation_details', compact('token_data'));
        // }
    }
    
    public function transfer_zero()
    {

        $wrong_transactions = DB::table('nst_prepare_products as npp')
            ->select(
                        DB::raw(' npp.id as id '),
                        DB::raw(' t.ref_no as ref_no ')
                    )
            ->leftjoin('transactions as t','npp.transaction_id', '=', 't.id')
            ->whereNull('npp.deleted_at')
            ->where('t.final_total' , 0)
            // ->where('npp.transaction_date' , '>=' , '2024-11-07 00:00:00')
            ->where('npp.status' , 'complete')
            ->get();
            
        return view('additional_reports.transfer_zero', compact('wrong_transactions'));
    }
    
    public function fix_transfer_zero()
    {

        $wrong_transactions = DB::table('nst_prepare_products as npp')
            ->select(
                        DB::raw(' npp.id as id '),
                        DB::raw(' t.ref_no as ref_no ')
                    )
            ->leftjoin('transactions as t','npp.transaction_id', '=', 't.id')
            ->whereNull('npp.deleted_at')
            ->where('t.final_total' , 0)
            ->where('npp.transaction_date' , '>=' , '2024-11-07 00:00:00')
            ->where('npp.status' , 'complete')
            ->get();
            
        foreach ($wrong_transactions as $wrong_transaction) {
            // Get all prepare products for this transaction with their weighted average prices
            $priceData = DB::table('nst_prepare_products')
                ->select([
                    'nst_prepare_products.id',
                    'nst_prepare_products.transaction_id',
                    'nst_prepare_products.transfer_quantity',
                    'nst_prepare_products.variation_id',
                    DB::raw('
                        CASE 
                            WHEN COUNT(DISTINCT transaction_sell_lines_purchase_lines.id) > 1 
                            THEN SUM(
                                CASE 
                                    WHEN nst_prepare_products.variation_id = purchase_lines.variation_id 
                                    THEN transaction_sell_lines_purchase_lines.quantity * purchase_lines.purchase_price_inc_tax 
                                    ELSE 0 
                                END
                            ) / 
                            SUM(
                                CASE 
                                    WHEN nst_prepare_products.variation_id = purchase_lines.variation_id 
                                    THEN transaction_sell_lines_purchase_lines.quantity 
                                    ELSE 0 
                                END
                            )
                            ELSE MAX(
                                CASE 
                                    WHEN nst_prepare_products.variation_id = purchase_lines.variation_id 
                                    THEN purchase_lines.purchase_price_inc_tax 
                                    ELSE NULL 
                                END
                            )
                        END as purchase_price_inc_tax
                    ')
                ])
                ->leftJoin('transactions', 'transactions.id', '=', 'nst_prepare_products.transaction_id')
                ->leftJoin('transaction_sell_lines', 'transactions.id', '=', 'transaction_sell_lines.transaction_id')
                ->leftJoin('transaction_sell_lines_purchase_lines', 'transaction_sell_lines_purchase_lines.sell_line_id', '=', 'transaction_sell_lines.id')
                ->leftJoin('purchase_lines', 'purchase_lines.id', '=', 'transaction_sell_lines_purchase_lines.purchase_line_id')
                ->where('nst_prepare_products.transaction_id', function($query) use ($wrong_transaction) {
                    $query->select('transaction_id')
                          ->from('nst_prepare_products')
                          ->where('id', $wrong_transaction->id)
                          ->limit(1);
                })
                ->groupBy([
                    'nst_prepare_products.id',
                    'nst_prepare_products.transaction_id',
                    'nst_prepare_products.transfer_quantity',
                    'nst_prepare_products.variation_id'
                ])
                ->get();
            
            if ($priceData->isNotEmpty()) {
                // Calculate total for all variations in this transaction
                $total = $priceData->sum(function($item) {
                    return $item->transfer_quantity * $item->purchase_price_inc_tax;
                });
                
                foreach ($priceData as $item) {
                    // 1. Update purchase_lines for each variation
                    DB::table('purchase_lines')
                        ->join('nst_prepare_products', 'purchase_lines.transaction_id', '=', DB::raw('nst_prepare_products.transaction_id + 1'))
                        ->where('nst_prepare_products.id', $item->id)
                        ->where('purchase_lines.variation_id', $item->variation_id)
                        ->update([
                            'purchase_price' => $item->purchase_price_inc_tax,
                            'purchase_price_inc_tax' => $item->purchase_price_inc_tax
                        ]);

                    // 2. Update transaction_sell_lines for each variation
                    DB::table('transaction_sell_lines')
                        ->join('nst_prepare_products', 'transaction_sell_lines.transaction_id', '=', 'nst_prepare_products.transaction_id')
                        ->where('nst_prepare_products.id', $item->id)
                        ->where('transaction_sell_lines.variation_id', $item->variation_id)
                        ->update([
                            'unit_price' => $item->purchase_price_inc_tax,
                            'unit_price_before_discount' => $item->purchase_price_inc_tax,
                            'unit_price_inc_tax' => $item->purchase_price_inc_tax
                        ]);
                
                    // 3. Update nst_prepare_products for each variation
                    DB::table('nst_prepare_products')
                        ->where('id', $item->id)
                        ->update([
                            'unit_price_after_shipping' => $item->purchase_price_inc_tax
                        ]);
                }
                
                // Get the transaction_id for this group of prepare products
                $transaction_id = $priceData->first()->transaction_id;
                
                // 4. Update original transaction with total sum
                DB::table('transactions')
                    ->where('id', $transaction_id)
                    ->update([
                        'total_before_tax' => $total,
                        'final_total' => $total
                    ]);
            
                // 5. Update transaction_id + 1 with same total
                DB::table('transactions')
                    ->where('id', $transaction_id + 1)
                    ->update([
                        'total_before_tax' => $total,
                        'final_total' => $total
                    ]);
            }
        }

            
        return view('additional_reports.fix_transfer_zero', compact('wrong_transactions'));
    }
    
    public function fixTransferZero()
    {
        \Log::info('Fix Transfer Zero started successfully');
        // Security check - verify the secret token
        if ($secret_token !== config('app.cron_secret')) {
            abort(403, 'Unauthorized access');
        }
        
        $wrong_transactions = DB::table('nst_prepare_products as npp')
            ->select(
                        DB::raw(' npp.id as id '),
                        DB::raw(' t.ref_no as ref_no ')
                    )
            ->leftjoin('transactions as t','npp.transaction_id', '=', 't.id')
            ->whereNull('npp.deleted_at')
            ->where('t.final_total' , 0)
            ->where('npp.transaction_date' , '>=' , '2024-11-07 00:00:00')
            ->where('npp.status' , 'complete')
            ->get();
            
        foreach ($wrong_transactions as $wrong_transaction) {
            // Get all prepare products for this transaction with their weighted average prices
            $priceData = DB::table('nst_prepare_products')
                ->select([
                    'nst_prepare_products.id',
                    'nst_prepare_products.transaction_id',
                    'nst_prepare_products.transfer_quantity',
                    'nst_prepare_products.variation_id',
                    DB::raw('
                        CASE 
                            WHEN COUNT(DISTINCT transaction_sell_lines_purchase_lines.id) > 1 
                            THEN SUM(
                                CASE 
                                    WHEN nst_prepare_products.variation_id = purchase_lines.variation_id 
                                    THEN transaction_sell_lines_purchase_lines.quantity * purchase_lines.purchase_price_inc_tax 
                                    ELSE 0 
                                END
                            ) / 
                            SUM(
                                CASE 
                                    WHEN nst_prepare_products.variation_id = purchase_lines.variation_id 
                                    THEN transaction_sell_lines_purchase_lines.quantity 
                                    ELSE 0 
                                END
                            )
                            ELSE MAX(
                                CASE 
                                    WHEN nst_prepare_products.variation_id = purchase_lines.variation_id 
                                    THEN purchase_lines.purchase_price_inc_tax 
                                    ELSE NULL 
                                END
                            )
                        END as purchase_price_inc_tax
                    ')
                ])
                ->leftJoin('transactions', 'transactions.id', '=', 'nst_prepare_products.transaction_id')
                ->leftJoin('transaction_sell_lines', 'transactions.id', '=', 'transaction_sell_lines.transaction_id')
                ->leftJoin('transaction_sell_lines_purchase_lines', 'transaction_sell_lines_purchase_lines.sell_line_id', '=', 'transaction_sell_lines.id')
                ->leftJoin('purchase_lines', 'purchase_lines.id', '=', 'transaction_sell_lines_purchase_lines.purchase_line_id')
                ->where('nst_prepare_products.transaction_id', function($query) use ($wrong_transaction) {
                    $query->select('transaction_id')
                          ->from('nst_prepare_products')
                          ->where('id', $wrong_transaction->id)
                          ->limit(1);
                })
                ->groupBy([
                    'nst_prepare_products.id',
                    'nst_prepare_products.transaction_id',
                    'nst_prepare_products.transfer_quantity',
                    'nst_prepare_products.variation_id'
                ])
                ->get();
            
            if ($priceData->isNotEmpty()) {
                // Calculate total for all variations in this transaction
                $total = $priceData->sum(function($item) {
                    return $item->transfer_quantity * $item->purchase_price_inc_tax;
                });
                
                foreach ($priceData as $item) {
                    // 1. Update purchase_lines for each variation
                    DB::table('purchase_lines')
                        ->join('nst_prepare_products', 'purchase_lines.transaction_id', '=', DB::raw('nst_prepare_products.transaction_id + 1'))
                        ->where('nst_prepare_products.id', $item->id)
                        ->where('purchase_lines.variation_id', $item->variation_id)
                        ->update([
                            'purchase_price' => $item->purchase_price_inc_tax,
                            'purchase_price_inc_tax' => $item->purchase_price_inc_tax
                        ]);

                    // 2. Update transaction_sell_lines for each variation
                    DB::table('transaction_sell_lines')
                        ->join('nst_prepare_products', 'transaction_sell_lines.transaction_id', '=', 'nst_prepare_products.transaction_id')
                        ->where('nst_prepare_products.id', $item->id)
                        ->where('transaction_sell_lines.variation_id', $item->variation_id)
                        ->update([
                            'unit_price' => $item->purchase_price_inc_tax,
                            'unit_price_before_discount' => $item->purchase_price_inc_tax,
                            'unit_price_inc_tax' => $item->purchase_price_inc_tax
                        ]);
                
                    // 3. Update nst_prepare_products for each variation
                    DB::table('nst_prepare_products')
                        ->where('id', $item->id)
                        ->update([
                            'unit_price_after_shipping' => $item->purchase_price_inc_tax
                        ]);
                }
                
                // Get the transaction_id for this group of prepare products
                $transaction_id = $priceData->first()->transaction_id;
                
                // 4. Update original transaction with total sum
                DB::table('transactions')
                    ->where('id', $transaction_id)
                    ->update([
                        'total_before_tax' => $total,
                        'final_total' => $total
                    ]);
            
                // 5. Update transaction_id + 1 with same total
                DB::table('transactions')
                    ->where('id', $transaction_id + 1)
                    ->update([
                        'total_before_tax' => $total,
                        'final_total' => $total
                    ]);
            }
        }

            \Log::info($wrong_transactions);
            \Log::info('Fix Transfer Zero completed successfully');
        return response()->json(['status' => 'success', 'message' => 'fixed transfer zero']);
    }
    
    public function transfer_wrong_purchase_price()
    {

        $results = DB::table('nst_prepare_products as npp')
            ->select(
                        DB::raw(' npp.id as id '),
                        DB::raw(' t.ref_no as ref_no ')
                    )
            ->leftjoin('transactions as t','npp.transaction_id', '=', 't.id')
            ->whereNull('npp.deleted_at')
            ->where('npp.unit_price_after_shipping' , 0)
            ->where('t.final_total' , '!=' , 0)
            // ->where('npp.transaction_date' , '>=' , '2024-11-07 00:00:00')
            ->where('npp.status' , 'complete')
            ->get();
        return view('additional_reports.transfer_wrong_purchase_price', compact('results'));
    }
    
    public function fix_transfer_wrong_purchase_price()
    {

        $results = DB::table('nst_prepare_products as npp')
            ->select(
                        DB::raw(' npp.id as id '),
                        DB::raw(' t.ref_no as ref_no ')
                    )
            ->leftjoin('transactions as t','npp.transaction_id', '=', 't.id')
            ->whereNull('npp.deleted_at')
            ->where('npp.unit_price_after_shipping' , 0)
            ->where('t.final_total' , '!=' , 0)
            // ->where('npp.transaction_date' , '>=' , '2024-11-07 00:00:00')
            ->where('npp.status' , 'complete')
            ->get();
            
        foreach ($results as $result) {
            // Get all prepare products for this transaction with their weighted average prices
            $priceData = DB::table('nst_prepare_products')
                ->select([
                    'nst_prepare_products.id',
                    'nst_prepare_products.transaction_id',
                    'nst_prepare_products.transfer_quantity',
                    'nst_prepare_products.variation_id',
                    DB::raw('
                        CASE 
                            WHEN COUNT(DISTINCT transaction_sell_lines_purchase_lines.id) > 1 
                            THEN SUM(
                                CASE 
                                    WHEN nst_prepare_products.variation_id = purchase_lines.variation_id 
                                    THEN transaction_sell_lines_purchase_lines.quantity * purchase_lines.purchase_price_inc_tax 
                                    ELSE 0 
                                END
                            ) / 
                            SUM(
                                CASE 
                                    WHEN nst_prepare_products.variation_id = purchase_lines.variation_id 
                                    THEN transaction_sell_lines_purchase_lines.quantity 
                                    ELSE 0 
                                END
                            )
                            ELSE MAX(
                                CASE 
                                    WHEN nst_prepare_products.variation_id = purchase_lines.variation_id 
                                    THEN purchase_lines.purchase_price_inc_tax 
                                    ELSE NULL 
                                END
                            )
                        END as purchase_price_inc_tax
                    ')
                ])
                ->leftJoin('transactions', 'transactions.id', '=', 'nst_prepare_products.transaction_id')
                ->leftJoin('transaction_sell_lines', 'transactions.id', '=', 'transaction_sell_lines.transaction_id')
                ->leftJoin('transaction_sell_lines_purchase_lines', 'transaction_sell_lines_purchase_lines.sell_line_id', '=', 'transaction_sell_lines.id')
                ->leftJoin('purchase_lines', 'purchase_lines.id', '=', 'transaction_sell_lines_purchase_lines.purchase_line_id')
                ->where('nst_prepare_products.transaction_id', function($query) use ($result) {
                    $query->select('transaction_id')
                          ->from('nst_prepare_products')
                          ->where('id', $result->id)
                          ->limit(1);
                })
                ->groupBy([
                    'nst_prepare_products.id',
                    'nst_prepare_products.transaction_id',
                    'nst_prepare_products.transfer_quantity',
                    'nst_prepare_products.variation_id'
                ])
                ->get();
                
            if ($priceData->isNotEmpty()) {
                // Calculate total for all variations in this transaction
                $total = $priceData->sum(function($item) {
                    return $item->transfer_quantity * $item->purchase_price_inc_tax;
                });
                
                foreach ($priceData as $item) {
                    // 1. Update purchase_lines for each variation
                    DB::table('purchase_lines')
                        ->join('nst_prepare_products', 'purchase_lines.transaction_id', '=', DB::raw('nst_prepare_products.transaction_id + 1'))
                        ->where('nst_prepare_products.id', $item->id)
                        ->where('purchase_lines.variation_id', $item->variation_id)
                        ->update([
                            'purchase_price' => $item->purchase_price_inc_tax,
                            'purchase_price_inc_tax' => $item->purchase_price_inc_tax
                        ]);

                    // 2. Update transaction_sell_lines for each variation
                    DB::table('transaction_sell_lines')
                        ->join('nst_prepare_products', 'transaction_sell_lines.transaction_id', '=', 'nst_prepare_products.transaction_id')
                        ->where('nst_prepare_products.id', $item->id)
                        ->where('transaction_sell_lines.variation_id', $item->variation_id)
                        ->update([
                            'unit_price' => $item->purchase_price_inc_tax,
                            'unit_price_before_discount' => $item->purchase_price_inc_tax,
                            'unit_price_inc_tax' => $item->purchase_price_inc_tax
                        ]);
                
                    // 3. Update nst_prepare_products for each variation
                    DB::table('nst_prepare_products')
                        ->where('id', $item->id)
                        ->update([
                            'unit_price_after_shipping' => $item->purchase_price_inc_tax
                        ]);
                }
                
                // Get the transaction_id for this group of prepare products
                $transaction_id = $priceData->first()->transaction_id;
                
                // 4. Update original transaction with total sum
                DB::table('transactions')
                    ->where('id', $transaction_id)
                    ->update([
                        'total_before_tax' => $total,
                        'final_total' => $total
                    ]);
            
                // 5. Update transaction_id + 1 with same total
                DB::table('transactions')
                    ->where('id', $transaction_id + 1)
                    ->update([
                        'total_before_tax' => $total,
                        'final_total' => $total
                    ]);
            }
        }
        
        return view('additional_reports.fix_transfer_wrong_purchase_price', compact('results'));
    }
    
    public function fixTransferWrongPurchasePrice()
    {
        \Log::info('Fix Transfer Wrong Purchase Price started successfully');
        // Security check - verify the secret token
        if ($secret_token !== config('app.cron_secret')) {
            abort(403, 'Unauthorized access');
        }
        
        $results = DB::table('nst_prepare_products as npp')
            ->select(
                        DB::raw(' npp.id as id '),
                        DB::raw(' t.ref_no as ref_no ')
                    )
            ->leftjoin('transactions as t','npp.transaction_id', '=', 't.id')
            ->whereNull('npp.deleted_at')
            ->where('npp.unit_price_after_shipping' , 0)
            ->where('t.final_total' , '!=' , 0)
            // ->where('npp.transaction_date' , '>=' , '2024-11-07 00:00:00')
            ->where('npp.status' , 'complete')
            ->get();
            
        foreach ($results as $result) {
            // Get all prepare products for this transaction with their weighted average prices
            $priceData = DB::table('nst_prepare_products')
                ->select([
                    'nst_prepare_products.id',
                    'nst_prepare_products.transaction_id',
                    'nst_prepare_products.transfer_quantity',
                    'nst_prepare_products.variation_id',
                    DB::raw('
                        CASE 
                            WHEN COUNT(DISTINCT transaction_sell_lines_purchase_lines.id) > 1 
                            THEN SUM(
                                CASE 
                                    WHEN nst_prepare_products.variation_id = purchase_lines.variation_id 
                                    THEN transaction_sell_lines_purchase_lines.quantity * purchase_lines.purchase_price_inc_tax 
                                    ELSE 0 
                                END
                            ) / 
                            SUM(
                                CASE 
                                    WHEN nst_prepare_products.variation_id = purchase_lines.variation_id 
                                    THEN transaction_sell_lines_purchase_lines.quantity 
                                    ELSE 0 
                                END
                            )
                            ELSE MAX(
                                CASE 
                                    WHEN nst_prepare_products.variation_id = purchase_lines.variation_id 
                                    THEN purchase_lines.purchase_price_inc_tax 
                                    ELSE NULL 
                                END
                            )
                        END as purchase_price_inc_tax
                    ')
                ])
                ->leftJoin('transactions', 'transactions.id', '=', 'nst_prepare_products.transaction_id')
                ->leftJoin('transaction_sell_lines', 'transactions.id', '=', 'transaction_sell_lines.transaction_id')
                ->leftJoin('transaction_sell_lines_purchase_lines', 'transaction_sell_lines_purchase_lines.sell_line_id', '=', 'transaction_sell_lines.id')
                ->leftJoin('purchase_lines', 'purchase_lines.id', '=', 'transaction_sell_lines_purchase_lines.purchase_line_id')
                ->where('nst_prepare_products.transaction_id', function($query) use ($result) {
                    $query->select('transaction_id')
                          ->from('nst_prepare_products')
                          ->where('id', $result->id)
                          ->limit(1);
                })
                ->groupBy([
                    'nst_prepare_products.id',
                    'nst_prepare_products.transaction_id',
                    'nst_prepare_products.transfer_quantity',
                    'nst_prepare_products.variation_id'
                ])
                ->get();
                
            if ($priceData->isNotEmpty()) {
                // Calculate total for all variations in this transaction
                $total = $priceData->sum(function($item) {
                    return $item->transfer_quantity * $item->purchase_price_inc_tax;
                });
                
                foreach ($priceData as $item) {
                    // 1. Update purchase_lines for each variation
                    DB::table('purchase_lines')
                        ->join('nst_prepare_products', 'purchase_lines.transaction_id', '=', DB::raw('nst_prepare_products.transaction_id + 1'))
                        ->where('nst_prepare_products.id', $item->id)
                        ->where('purchase_lines.variation_id', $item->variation_id)
                        ->update([
                            'purchase_price' => $item->purchase_price_inc_tax,
                            'purchase_price_inc_tax' => $item->purchase_price_inc_tax
                        ]);

                    // 2. Update transaction_sell_lines for each variation
                    DB::table('transaction_sell_lines')
                        ->join('nst_prepare_products', 'transaction_sell_lines.transaction_id', '=', 'nst_prepare_products.transaction_id')
                        ->where('nst_prepare_products.id', $item->id)
                        ->where('transaction_sell_lines.variation_id', $item->variation_id)
                        ->update([
                            'unit_price' => $item->purchase_price_inc_tax,
                            'unit_price_before_discount' => $item->purchase_price_inc_tax,
                            'unit_price_inc_tax' => $item->purchase_price_inc_tax
                        ]);
                
                    // 3. Update nst_prepare_products for each variation
                    DB::table('nst_prepare_products')
                        ->where('id', $item->id)
                        ->update([
                            'unit_price_after_shipping' => $item->purchase_price_inc_tax
                        ]);
                }
                
                // Get the transaction_id for this group of prepare products
                $transaction_id = $priceData->first()->transaction_id;
                
                // 4. Update original transaction with total sum
                DB::table('transactions')
                    ->where('id', $transaction_id)
                    ->update([
                        'total_before_tax' => $total,
                        'final_total' => $total
                    ]);
            
                // 5. Update transaction_id + 1 with same total
                DB::table('transactions')
                    ->where('id', $transaction_id + 1)
                    ->update([
                        'total_before_tax' => $total,
                        'final_total' => $total
                    ]);
            }
        }
        
        \Log::info($results);
        \Log::info('Fix Transfer Wrong Purchase Price completed successfully');
        return response()->json(['status' => 'success', 'message' => 'fixed transfer wrong purchase price']);
    }
    
    public function uploadPdf(Request $request)
    {
        // Force JSON response
        $request->headers->set('Accept', 'application/json');
        
        try {
            if (!$request->hasFile('pdf')) {
                return response()->json([
                    'success' => false,
                    'error' => 'No PDF file uploaded'
                ], 400);
            }
            
            $file = $request->file('pdf');
            
            if (!$file->isValid()) {
                return response()->json([
                    'success' => false,
                    'error' => 'Invalid file uploaded'
                ], 400);
            }
            
            $fileName = 'products_report_' . time() . '_' . uniqid() . '.pdf';
            $directory = 'reports';
            
            // Ensure directory exists with correct permissions
            if (!Storage::exists($directory)) {
                Storage::makeDirectory($directory);
                
                // Set directory permissions to 0755
                $fullPath = Storage::path($directory);
                chmod($fullPath, 0755);
                
                // Log directory creation and permissions
                Log::info("Created directory {$fullPath} with permissions 0755");
            }
            
            // Store the file
            $path = Storage::putFileAs($directory, $file, $fileName);
            
            if (!$path) {
                return response()->json([
                    'success' => false,
                    'error' => 'Failed to store file'
                ], 500);
            }
            
            // Set file permissions to 0644 (readable by all)
            $fullFilePath = Storage::path($path);
            chmod($fullFilePath, 0644);
            
            // Verify permissions were set correctly
            $perms = fileperms($fullFilePath);
            if (($perms & 0777) !== 0644) {
                Log::warning("Failed to set correct permissions for {$fullFilePath}");
                return response()->json([
                    'success' => false,
                    'error' => 'Failed to set file permissions'
                ], 500);
            }
            
            // Generate public URL
            $publicUrl = 'https://static-egy.com/uploads/reports/' . $fileName;
            
            // Log successful upload
            Log::info("Successfully uploaded PDF: {$fileName} with permissions 0644");
            
            return response()->json([
                'success' => true,
                'pdfUrl' => $publicUrl
            ])->header('Content-Type', 'application/json');
            
        } catch (\Exception $e) {
            Log::error('PDF upload failed: ' . $e->getMessage());
            
            return response()->json([
                'success' => false,
                'error' => $e->getMessage()
            ], 500)->header('Content-Type', 'application/json');
        }
    }
    
    public function product_extra_info()
    {

        $business_id = request()->session()->get('user.business_id');

        return view('additional_reports.product_extra_info');
    }
    
    public function product_extra_info_details(Request $request)
    {
        // dd($request);
        $business_id = request()->session()->get('user.business_id');
        $product_sku = $request->product_sku;

        $product = DB::table('products')
            ->select(
                        DB::raw(' id '),
                        DB::raw(' name '),
                        DB::raw(' sku '),
                        DB::raw(' product_custom_field1 '),
                        DB::raw(' product_custom_field2 '),
                        DB::raw(' product_custom_field3 ')
                    )
            ->where('business_id' , $business_id)
            ->where('sku' , 'like', '%'.$product_sku.'%')
            ->first();
            
        // Fetch existing compatible serials and products
        $compatibles = DB::table('product_compatibles')
            ->where('product_id', $product->id)
            ->get();
            
        // Separate serials and products
        $compatibleSerials = [];
        $compatibleProductIds = [];
        
        foreach ($compatibles as $compatible) {
            if ($compatible->compatible_product_id == 0) {
                // This is a serial
                $compatibleSerials[] = $compatible->compatible_with;
            } else {
                // This is a product
                $compatibleProductIds[] = $compatible->compatible_product_id;
            }
        }
        
        // Get compatible product details
        $compatibleProducts = [];
        if (!empty($compatibleProductIds)) {
            $compatibleProducts = DB::table('products')
                ->select('id', 'name', 'sku')
                ->whereIn('id', $compatibleProductIds)
                ->get();
        }
        
        return view('additional_reports.product_extra_info_details', compact('product', 'compatibleSerials', 'compatibleProducts'));
    }
    
    public function products_search(Request $request)
    {
        $search = $request->get('search');
        
        $products = Product::where('sku', 'like', "%{$search}%")
            ->orWhere('name', 'like', "%{$search}%")
            ->paginate(10);
    
        $results = $products->map(function ($product) {
            return [
                'id' => $product->id,
                'text' => $product->name,
                'sku' => $product->sku,
                'name' => $product->name
            ];
        });
    
        return response()->json([
            'results' => $results,
            'pagination' => [
                'more' => $products->hasMorePages()
            ]
        ]);
    }
    
    public function product_extra_info_store(Request $request)
    {
        // Validate the incoming request
        $validated = $request->validate([
            'product_id' => 'required|exists:products,id',
            'compatible_serials' => 'nullable|array',
            'compatible_products' => 'nullable|array',
        ]);
        
        $productId = $request->input('product_id');
        $compatibleSerials = $request->input('compatible_serials', []);
        $compatibleProducts = $request->input('compatible_products', []);
        
        // Get existing compatibles to compare for updates
        $existingCompatibles = DB::table('product_compatibles')
            ->where('product_id', $productId)
            ->get();
        
        // Create collections for easier comparison
        $existingSerials = collect($existingCompatibles)
            ->where('compatible_product_id', 0)
            ->pluck('compatible_with')
            ->toArray();
            
        $existingProductIds = collect($existingCompatibles)
            ->where('compatible_product_id', '>', 0)
            ->pluck('compatible_product_id')
            ->toArray();
            
        // Filter out empty values from input serials
        $compatibleSerials = array_filter($compatibleSerials, function($serial) {
            return !empty(trim($serial));
        });
        
        // First delete removed serials
        $serialsToDelete = array_diff($existingSerials, $compatibleSerials);
        if (!empty($serialsToDelete)) {
            DB::table('product_compatibles')
                ->where('product_id', $productId)
                ->where('compatible_product_id', 0)
                ->whereIn('compatible_with', $serialsToDelete)
                ->delete();
        }
        
        // Insert new serials
        $serialsToAdd = array_diff($compatibleSerials, $existingSerials);
        foreach ($serialsToAdd as $serial) {
            DB::table('product_compatibles')->insert([
                'product_id' => $productId,
                'compatible_product_id' => 0,
                'compatible_with' => $serial,
                'created_at' => now(),
                'updated_at' => now()
            ]);
        }
        
        // Delete removed product compatibilities
        $productsToDelete = array_diff($existingProductIds, $compatibleProducts);
        if (!empty($productsToDelete)) {
            DB::table('product_compatibles')
                ->where('product_id', $productId)
                ->whereIn('compatible_product_id', $productsToDelete)
                ->delete();
        }
        
        // Insert new product compatibilities
        $productsToAdd = array_diff($compatibleProducts, $existingProductIds);
        foreach ($productsToAdd as $compatibleProductId) {
            DB::table('product_compatibles')->insert([
                'product_id' => $productId,
                'compatible_product_id' => $compatibleProductId,
                'compatible_with' => 'product_relation',
                'created_at' => now(),
                'updated_at' => now()
            ]);
        }
        
        // Redirect back with success message
        return redirect('additional_reports/product_extra_info')->with('status', 'Compatible products and serials saved successfully!');
    }
    
    /**
     * Create a public share link for selected products
     * 
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function createPublicShare(Request $request)
    {
        try {
            // Validate request
            if (!$request->has('products') || !is_array($request->products)) {
                return response()->json([
                    'success' => false,
                    'error' => 'Invalid data format'
                ], 400);
            }
    
            $business_id = request()->session()->get('user.business_id');
            $user_id = auth()->user()->id;
            
            // Generate a unique token for this share
            $shareToken = md5(uniqid() . time());
            
            // Calculate expiration (243 hours from now "7 days")
            $expiresAt = now()->addHours(243);
            
            // Store in database
            DB::table('shared_products')->insert([
                'token' => $shareToken,
                'business_id' => $business_id,
                'user_id' => $user_id,
                'products_data' => json_encode($request->products),
                'expires_at' => $expiresAt
            ]);
            
            // Generate a public URL
            $shareUrl = url("/shared-products/{$shareToken}");
            
            return response()->json([
                'success' => true,
                'shareUrl' => $shareUrl,
                'expiresAt' => $expiresAt->format('Y-m-d H:i:s')
            ]);
                
        } catch (\Exception $e) {
            \Log::error('Error creating public share: ' . $e->getMessage());
            
            return response()->json([
                'success' => false,
                'error' => $e->getMessage()
            ], 500);
        }
    }
    
    /**
     * Display shared products page
     * 
     * @param string $token
     * @return \Illuminate\View\View
     */
    public function viewSharedProducts($token)
    {
        // Find the shared data in the database
        $sharedData = DB::table('shared_products')->where('token', $token)
                                    ->where('expires_at', '>', now())  // Using the scope to get only non-expired links
                                   ->first();
        
        if (!$sharedData) {
            // Handle invalid or expired token
            return view('additional_reports.shared_products_error');
        }
        $products = json_decode($sharedData->products_data, true);
        $expiresAt = \Carbon\Carbon::parse($sharedData->expires_at);
        // dd($products);

        return view('additional_reports.shared_products', compact('products', 'token', 'expiresAt'));
    }
    
    /**
     * Schedule cleanup of expired shared products
     * This should be called from a scheduler
     */
    public function cleanupExpiredShares()
    {
        // Delete expired shared products
        $deleted = DB::table('shared_products')->where('expires_at', '<', now())->delete();
        
        \Log::info("Cleaned up {$deleted} expired shared products");
        
        return response()->json([
            'success' => true,
            'message' => "Cleaned up {$deleted} expired shared product shares"
        ]);
    }
    
    
    public function product_racks()
    {

        $business_id = request()->session()->get('user.business_id');
        $permitted_locations = auth()->user()->permitted_locations();
        
        $business_locations = BusinessLocation::select(
                        DB::raw(' id '),
                        DB::raw(' name '),
                        DB::raw(' location_id ')
                    );
       if ($permitted_locations != 'all') {
            $business_locations->whereIn('id' , $permitted_locations);
        }
        $business_locations = $business_locations->get();
        
        $brands = Brands::where('business_id', $business_id)
            ->select(
                        DB::raw(' id '),
                        DB::raw(' name ')
                    )
            ->get();
        
        $data = Category::where('business_id', $business_id)
            ->select(
                        DB::raw(' id '),
                        DB::raw(' name '),
                        DB::raw(' parent_id ')
                    )
            ->where('category_type' , 'product')
            ->get();

        return view('additional_reports.product_racks', compact('data' , 'business_locations' , 'brands'));
    }
    
    public function product_racks_details(Request $request)
    {
        $business_id = request()->session()->get('user.business_id');
        $brand_ids = $request->brands;
        $category_ids = $request->categories;
        $subCategory_ids = $request->subcategories;
        $business_locations = $request->business_locations;
        

        $products = DB::table('product_racks as pr')
            ->select(
                        // DB::raw(' p.id as p_id '),
                        // DB::raw(' vld.id as vld_id '),
                        // DB::raw(' pr.id as pr_id '),
                        // DB::raw(' v.id as v_id '),
                        DB::raw(' IF(v.name = "DUMMY", p.name , CONCAT(p.name, " + ", v.name)) as product_name '),
                        DB::raw(' v.sub_sku as product_sku '),
                        DB::raw(' p.image as product_image '),
                        DB::raw(' v.sell_price_inc_tax as sell_price_inc_tax '),
                        DB::raw(' vld.qty_available as qty_available '),
                        DB::raw(' bl.name as business_location '),
                        DB::raw(' pr.rack as rack '),
                        DB::raw(' pr.row as row '),
                        DB::raw(' pr.position as position ')
                    )
            ->leftjoin('products as p','pr.product_id', '=', 'p.id')
            ->leftjoin('variations as v','v.product_id', '=', 'pr.product_id')
            ->leftjoin('variation_location_details as vld','vld.variation_id', '=', 'v.id')
            ->leftjoin('business_locations as bl','bl.id', '=', 'pr.location_id')
            ->where('pr.business_id' , $business_id)
            ->where('vld.qty_available' , '>', 0)
            ->whereNotNull('pr.rack');
            // ->where('p.id' , 3836);
            if ($business_locations != null) {
                $products->whereIn('pr.location_id' , $business_locations)
                         ->whereIn('vld.location_id' , $business_locations);
            }
            if ($brand_ids != null) {
                $products->whereIn('p.brand_id' , $brand_ids);
            }
            if ($category_ids != null) {
                $products->whereIn('p.category_id' , $category_ids);
            }
            if ($subCategory_ids != null) {
                $products->whereIn('p.sub_category_id' , $subCategory_ids);
            }
            $products = $products->orderBy('product_sku')->get();
                    
// dd($products);
        return view('additional_reports.product_racks_details', compact('products'));
    }
}