<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::group(['middleware' => [
    'web', 'authh', 'auth', 'SetSessionData', 'language', 'timezone', 'AdminSidebarMenu'
]], function () {
    Route::group(['prefix' => 'stock-issues'], function () {
        Route::get('/install', 'InstallController@index');
        Route::get('/install/update', 'InstallController@update');
        Route::get('/install/uninstall', 'InstallController@uninstall');
        Route::get('/reports', 'StockReportController@index');
        Route::group(['middleware' => [
            \Illuminate\Routing\Middleware\ValidateSignature::class
        ]], function () {
            Route::get('/reports/{stock_report}/download', 'StockReportController@download')->name('stock-issues.reports.download');
            Route::get('/reports/{stock_report}/delete', 'StockReportController@delete')->name('stock-issues.reports.delete');
            Route::get('/reports/{stock_report}/permanently-delete', 'StockReportController@permanentlyDelete')->name('stock-issues.reports.permanently-delete');
        });
    });
});
