@extends('layouts.app')
@section('title', __('lang_v1.backup'))
@section('content')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            @lang('Stock Reports')
        </h1>
    </section>

    <!-- Main content -->
    <section class="content">
        @if (session('notification') || !empty($notification))
            <div class="row">
                <div class="col-sm-12">
                    <div class="alert alert-danger alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        @if(!empty($notification['msg']))
                            {{$notification['msg']}}
                        @elseif(session('notification.msg'))
                            {{ session('notification.msg') }}
                        @endif
                    </div>
                </div>
            </div>
        @endif

        <div class="row">
            <div class="col-sm-12">
                @component('components.filters', ['title' => __('report.filters'), 'class' => 'box-solid'])
                    <form action="{{ action('\Modules\StockIssues\Http\Controllers\StockReportController@index') }}">
                        <div class="col-md-3">
                            <div class="form-group">
                                {!! Form::label('filter_location_id',  __('purchase.business_location') . ':') !!}
                                {!! Form::select('filter_location_id', $business_locations, request('filter_location_id'), ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all') ]); !!}
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </form>
                    <br>
                    <hr>
                    <strong>To enable auto backup you must setup a cron job with this command:</strong><br>
                    <code>{{ $cronJob }}</code> <br>
                    <strong>To enable auto backup & fix you must setup a cron job with this command:</strong><br>
                    <code>{{ $cronJobFix }}</code>
                @endcomponent
                @if (!is_null($reports))
                    @component('components.widget', ['class' => 'box-primary'])
                        @if ($reports->count() > 0)
                            <table class="table table-striped table-bordered">
                                <thead>
                                <tr>
                                    <th>@lang('lang_v1.file')</th>
                                    <th>product count</th>
                                    <th>@lang('lang_v1.date')</th>
                                    <th>@lang('lang_v1.age')</th>
                                    <th>@lang('messages.actions')</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($reports as $report)
                                    <tr>
                                        <td>{{ basename($report->path) }}</td>
                                        <td>{{ $report->products_count }}</td>
                                        <td>{{ $report->created_at->toDateTimeString() }}</td>
                                        <td>{{ $report->created_at->diffForHumans(Carbon::now()) }}</td>
                                        <td>
                                            @if(is_null($report->deleted_at))
                                                <a class="btn btn-xs btn-success" target="_blank"
                                                   href="{{URL::signedRoute('stock-issues.reports.download', $report)}}">
                                                    <i class="fa fa-cloud-download"></i>
                                                    @lang('lang_v1.download')
                                                </a>
                                                @can('stock-issues.delete-reports')
                                                    <a class="btn btn-xs btn-danger link_confirmation"
                                                       data-button-type="delete"
                                                       href="{{URL::signedRoute('stock-issues.reports.delete', $report)}}">
                                                        <i class="fa fa-trash-o"></i>
                                                        @lang('messages.delete')
                                                    </a>
                                                @endcan
                                            @endif
                                            @can('stock-issues.pm-delete-reports')
                                                <a class="btn btn-xs btn-warning link_confirmation"
                                                   data-button-type="delete"
                                                   href="{{URL::signedRoute('stock-issues.reports.permanently-delete', $report)}}">
                                                    Permanently Delete
                                                </a>
                                            @endcan
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                            {{ $reports->appends(['filter_location_id' => request('filter_location_id', '')])->links() }}
                        @else
                            <div class="well">
                                <h4>There are no reports</h4>
                            </div>
                        @endif
                    @endcomponent
                @endif
            </div>
        </div>
    </section>
@endsection
