<?php

namespace Modules\StockIssues\Models;

use App\BusinessLocation;
use App\Product;
use App\ProductVariation;
use App\PurchaseLine;
use App\StockAdjustmentLine;
use App\TransactionSellLine;
use App\TransactionSellLinesPurchaseLines;
use App\Variation;

class VariationLocationDetails extends \App\VariationLocationDetails
{
    protected $casts = [
        'qty_available' => 'float',
        'variation_stock' => 'float',
        'purchase_lines_sold' => 'float',
        'purchase_lines_stock' => 'float',
    ];

    public function purchase_lines()
    {
        return $this->hasMany(PurchaseLine::class, 'variation_id', 'variation_id');
    }

    public function sell_lines()
    {
        return $this->hasMany(TransactionSellLine::class, 'variation_id', 'variation_id');
    }

    public function stock_adjust_lines()
    {
        return $this->hasMany(StockAdjustmentLine::class, 'variation_id', 'variation_id');
    }

    public function sell_line_purchase_lines()
    {
        return $this->hasManyThrough(TransactionSellLinesPurchaseLines::class, TransactionSellLine::class,
            'variation_id', 'sell_line_id', 'variation_id', 'id');
    }

    public function product_variation()
    {
        return $this->belongsTo(ProductVariation::class, 'product_variation_id');
    }

    public function variation()
    {
        return $this->belongsTo(Variation::class, 'variation_id');
    }

    public function location()
    {
        return $this->belongsTo(BusinessLocation::class, 'location_id');
    }

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }
}
