<?php

namespace Modules\StockIssues\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class StockIssuesMail extends Mailable
{
    use Queueable, SerializesModels;

    private $products;
    private $purchaseFixProducts;
    private $plNotFixed;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($products, $purchaseFixProducts, $plNotFixed)
    {
        $this->products = $products;
        $this->purchaseFixProducts = $purchaseFixProducts;
        $this->plNotFixed = $plNotFixed;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this
            ->subject('issues with ' . (count($this->products) + count($this->purchaseFixProducts) + count($this->plNotFixed)) . ' products')
            ->view('stock-issues::issues-table', [
                'products' => $this->products,
                'purchaseFixProducts' => $this->purchaseFixProducts,
                'plNotFixed' => $this->plNotFixed,
            ]);
    }
}

