<?php

namespace Modules\StockIssues\Console;

use Exception;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;
use Modules\StockIssues\Console\Methods\PurchaseLinesFixMethod;
use Modules\StockIssues\Console\Methods\StockFixMethod;
use Modules\StockIssues\Mail\StockIssuesMail;

class StockIssuesFix extends Command
{
    use StockFixMethod, PurchaseLinesFixMethod;

    /**
     * The console command name.
     *
     * @var string
     */
    protected $name = 'fix:stock';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Auto fix stock issues';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     * @throws Exception
     */
    public function handle()
    {
        $this->fix_stock($this, $products);
        $this->purchase_fix($this, $purchaseFixProducts, $plNotFixed);
        $this->sendmail($products ?? [], $purchaseFixProducts ?? [], $plNotFixed ?? []);
    }

    /**
     * @return void
     */
    private function sendmail($products, $purchaseFixProducts, $plNotFixed)
    {
        if (count($products) > 0 || count($purchaseFixProducts) > 0 || count($plNotFixed) > 0)
            // Mail::to('support@tps-egy.com')->sendNow(new StockIssuesMail($products, $purchaseFixProducts, $plNotFixed));
            return ('done');
        else
            // Mail::raw('fix command run without issues', function ($message) {
            //     $message->to('support@tps-egy.com')->subject('fix command');
            // });
                return ('no');
    }
}
