@extends('layouts.app')
@section('title', __('user.edit_user'))

@section('content')

    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>@lang( 'user.edit_user' )</h1>
    </section>

    <!-- Main content -->
    <section class="content">

        @component('components.widget', ['class' => 'box-primary', 'title' => str_replace( '#' . auth()->user()->business_id, '', $user->userFullName)])
            {!! Form::open(['url' => action('\Modules\TpsTransfer\Http\Controllers\TpsController@storeUserLocation', [$user->id]), 'method' => 'put']) !!}
                @foreach($types as $key => $index)
                    <hr>
                    <div class="row check_group">
                        <div class="col-md-2">
                            <h4>{{$index}}</h4>
                        </div>
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <?php
                                            if($key == 'receive'){
                                                $data = [
                                                        "tpsTransfer.location_access_{$key}_from_all_locations" => "(All) locations in {$index}",
                                                ];
                                            }else{
                                                $data = [
	                                                "tpsTransfer.location_access_{$key}_from_his_locations" => "(His accessed) locations in {$index}",
	                                                "tpsTransfer.location_access_{$key}_from_all_locations" => "(All) locations in {$index}",
                                                    "tpsTransfer.location_access_{$key}_from_selected_locations" => "(selected) locations in {$index}",
                                                ];
                                            }
                                        ?>
                                        {!! Form::label($key.'_from',  __('tpsTransfer::lang.from_locations').':') !!}
                                        {!! Form::select('data[]', $data, $userPermissions, ['class' => 'form-control select2 permission', 'style' => 'width:100%', 'data-key' => $key, 'data-destination' => 'from']); !!}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <?php
                                        if($key == 'prepare'){
                                            $data = [
                                                    "tpsTransfer.location_access_{$key}_to_all_locations" => "(All) locations in {$index}",
                                            ];
                                        }else{
                                            $data = [
	                                            "tpsTransfer.location_access_{$key}_to_his_locations" => "(His accessed) locations in {$index}",
	                                            "tpsTransfer.location_access_{$key}_to_all_locations" => "(All) locations in {$index}",
                                                "tpsTransfer.location_access_{$key}_to_selected_locations" => "(selected) locations in {$index}",
                                            ];
                                        }
                                        ?>
                                        {!! Form::label($key.'_to',  __('tpsTransfer::lang.to_locations').':') !!}
                                        {!! Form::select('data[]', $data, $userPermissions, ['class' => 'form-control select2 permission', 'style' => 'width:100%', 'data-key' => $key, 'data-destination' => 'to']); !!}
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div id='{{$key}}-from-selection-div' class="form-group hidden">
                                        {!! Form::label('locations['.$key.'_from]',  'Selected '.__('purchase.business_location') . ':') !!}
                                        {!! Form::select('locations['.$key.'_from][]', $locations, $userLocations->where('type', $key.'_from')->pluck('location_id'), ['class' => 'form-control select2', 'style' => 'width:100%', 'multiple']); !!}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div id='{{$key}}-to-selection-div' class="form-group hidden">
                                        {!! Form::label('locations['.$key.'_to]',  'Selected '.__('purchase.business_location') . ':') !!}
                                        {!! Form::select('locations['.$key.'_to][]', $locations, $userLocations->where('type', $key.'_to')->pluck('location_id'), ['class' => 'form-control select2', 'style' => 'width:100%', 'multiple']); !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
                <div class="row">
                    <div class="col-md-12">
                        <button type="submit" class="btn btn-primary pull-right">@lang( 'messages.save' )</button>
                    </div>
                </div>

            {!! Form::close() !!}
        @endcomponent
    </section>
    <!-- /.content -->
@endsection
@section('javascript')
    <script>
        $(document).on('change', '.permission', function (evt) {
            let key = $(evt.target).data('key');
            let destination = $(evt.target).data('destination');
            let value = $(evt.target).val();

            let div = $('#'+ key +'-'+ destination+'-selection-div')

            if(value === 'tpsTransfer.location_access_'+ key +'_'+ destination +'_selected_locations'){
                div.removeClass('hidden')
            }else{
                div.addClass('hidden')
            }
        });
        $('.permission').each(function(i, obj) {
            $(obj).change()
        });
    </script>
@endsection
