<div class="modal-dialog modal-xl" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close no-print" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title" id="modalTitle"> @lang('lang_v1.stock_transfer_details') (<b>@lang('purchase.ref_no'):</b> #{{ $nstProduct->id }})
            </h4>
        </div>
        <div class="modal-body">
            <div class="row invoice-info">
                <div class="col-sm-4 invoice-col">
                    @lang('lang_v1.location_from'):
                    <address>
                        <strong>{{ $nstProduct->from_location->name }}</strong>

                        @if(!empty($nstProduct->from_location->landmark))
                            <br>{{$nstProduct->from_location->landmark}}
                        @endif

                        @if(!empty($nstProduct->from_location->city) || !empty($nstProduct->from_location->state) || !empty($nstProduct->from_location->country))
                            <br>{{implode(',', array_filter([$nstProduct->from_location->city, $nstProduct->from_location->state, $nstProduct->from_location->country]))}}
                        @endif

                        @if(!empty($nstProduct->from_location->mobile))
                            <br>@lang('contact.mobile'): {{$nstProduct->from_location->mobile}}
                        @endif
                        @if(!empty($nstProduct->from_location->email))
                            <br>{{__('business.email')}}: {{$nstProduct->from_location->email}}
                        @endif
                    </address>
                </div>

                <div class="col-md-4 invoice-col">
                    @lang('lang_v1.location_to'):
                    <address>
                        <strong>{{ $nstProduct->to_location->name }}</strong>

                        @if(!empty($nstProduct->to_location->landmark))
                            <br>{{$nstProduct->to_location->landmark}}
                        @endif

                        @if(!empty($nstProduct->to_location->city) || !empty($nstProduct->to_location->state) || !empty($nstProduct->to_location->country))
                            <br>{{implode(',', array_filter([$nstProduct->to_location->city, $nstProduct->to_location->state, $nstProduct->to_location->country]))}}
                        @endif

                        @if(!empty($nstProduct->to_location->mobile))
                            <br>@lang('contact.mobile'): {{$nstProduct->to_location->mobile}}
                        @endif
                        @if(!empty($nstProduct->to_location->email))
                            <br>{{__('business.email')}}: {{$nstProduct->to_location->email}}
                        @endif
                    </address>
                </div>

                <div class="col-sm-4 invoice-col">
                    <b>@lang('purchase.ref_no'):</b> #{{ $nstProduct->ref_no }}<br/>
                    <b>@lang('messages.date'):</b> {{ @format_datetime($nstProduct->transaction_date) }}<br/>
                    <b>@lang('sale.status'):</b> {{$nstProduct->status ?? ''}}
                </div>
            </div>

            <br>
            <div class="row">
                <div class="col-xs-12">
                    <div class="table-responsive">
                        <table class="table bg-gray">
                            <tr class="bg-green">
                                <th>@lang('product.sku')</th>
                                <th>@lang('sale.product')</th>
                                <th>@lang('sale.qty')</th>
                                @can('view_purchase_price')
                                    <th>@lang('sale.unit_price')</th>
                                    <th>@lang('sale.subtotal')</th>
                                @endcan
                            </tr>
                            <tr>
                                <td>{{ $nstProduct->product->sku }}</td>
                                <td>
                                    {{ $nstProduct->product->name }}
                                    @if($nstProduct->purchase_line && !empty($nstProduct->purchase_line))
                                        @if(!empty($nstProduct->purchase_line->lot_number))
                                            {{$nstProduct->purchase_line->lot_number}}
                                        @endif
                                        @if(!empty($nstProduct->purchase_line->exp_date))
                                            - {{@format_date($nstProduct->purchase_line->exp_date)}}
                                        @endif
                                    @else
                                        <strong>@lang('lang_v1.lot_n_expiry')</strong>
                                    @endif
                                </td>
                                <td>{{ @format_quantity($nstProduct->transfer_quantity) }} @if(!empty($nstProduct->sub_unit)) {{$nstProduct->sub_unit->short_name}} @else {{$nstProduct->product->unit->short_name}} @endif</td>
                                @can('view_purchase_price')
                                    <td>
                                        <span class="display_currency" data-currency_symbol="true">{{ $nstProduct->unit_price_after_shipping }}</span>
                                    </td>
                                    <td>
                                        <span class="display_currency" data-currency_symbol="true">{{ $nstProduct->unit_price_after_shipping * $nstProduct->transfer_quantity }}</span>
                                    </td>
                                @endcan
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
            <br>
            @can('view_purchase_price')
                <div class="row">

                    <div class="col-xs-12 col-md-6 col-md-offset-6">
                        <div class="table-responsive">
                            <table class="table">
                                <tr>
                                    <th>@lang('lang_v1.purchase_price') @lang('sale.subtotal'): </th>
                                    <td></td>
                                    <td><span class="display_currency pull-right" data-currency_symbol="true">{{ $nstProduct->unit_price_after_shipping * $nstProduct->transfer_quantity }}</span></td>
                                </tr>
                                @if( !empty( $nstProduct->shipping ) )
                                    <tr>
                                        <th>@lang('purchase.additional_shipping_charges'):</th>
                                        <td><b>(+)</b></td>
                                        <td><span class="display_currency pull-right" data-currency_symbol="true">{{ floatval($nstProduct->value_per_unit) * floatval($transferQuantity) }}</span></td>
                                    </tr>
                                @endif
                                <tr>
                                    <th>@lang('purchase.purchase_total'):</th>
                                    <td></td>
                                    <td><span class="display_currency pull-right" data-currency_symbol="true" >{{ (floatval($nstProduct->value_per_unit) * floatval($nstProduct->transfer_quantity)) + (floatval($nstProduct->unit_price_after_shipping) * floatval($nstProduct->transfer_quantity)) }}</span></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            @endcan
            <div class="row">
                <div class="col-sm-6">
                    <strong>@lang('purchase.additional_notes'):</strong><br>
                    <p class="well well-sm no-shadow bg-gray">
                        @if($nstProduct->note)
                            {{ $nstProduct->note }}
                        @else
                            --
                        @endif
                    </p>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <strong>{{ __('lang_v1.activities') }}:</strong><br>
                    <table class="table table-condensed">
                        <tr>
                            <th>@lang('lang_v1.date')</th>
                            <th>@lang('messages.action')</th>
                            <th>@lang('lang_v1.by')</th>
                            <th>@lang('brand.note')</th>
                        </tr>
                        <tr>
                            <td>{{@format_datetime($nstProduct->created_at)}}</td>
                            <td>
                                {{__('lang_v1.created')}}
                            </td>
                            <td>
                                {{$nstProduct->createdBy->user_full_name ?? ''}}
                            </td>
                            <td>
                            </td>
                        </tr>
                        @if(!empty($activities))
                            @forelse($activities as $activity)
                                <tr>
                                    <td>{{@format_datetime($activity->created_at)}}</td>
                                    <td>
                                        {{__('lang_v1.' . $activity->description)}}
                                    </td>
                                    <td>
                                        {{$activity->causer->user_full_name ?? ''}}
                                        @if(!empty($activity->getExtraProperty('from_api')))
                                            <br>
                                            <span class="label bg-gray">{{$activity->getExtraProperty('from_api')}}</span>
                                        @endif

                                        @if(!empty($activity->getExtraProperty('is_automatic')))
                                            <span class="label bg-gray">@lang('lang_v1.automatic')</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($activity->description == 'edited')
                                            @php
                                              $diff = array_diff($activity->properties->toArray()['old'], $activity->properties->toArray()['attributes'])
                                            @endphp
                                            @foreach($diff as $attribute => $value)
                                                <b>{{__('tpsTransfer::lang.old')}} {!! $attribute !!}</b> : {!! $value !!}
                                            @endforeach
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="text-center">
                                        @lang('purchase.no_records_found')
                                    </td>
                                </tr>
                            @endforelse
                        @endif
                    </table>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-primary no-print" aria-label="Print"
                    onclick="$(this).closest('div.modal-content').printThis();"><i class="fa fa-print"></i> @lang( 'messages.print' )
            </button>
            <button type="button" class="btn btn-default no-print" data-dismiss="modal">@lang( 'messages.close' )</button>
        </div>
    </div>
</div>